/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFStatementMetaData;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

final class SnowflakePreparedStatementV1
extends SnowflakeStatementV1
implements PreparedStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakePreparedStatementV1.class);
    private final String sql;
    private SFStatementMetaData statementMetaData;
    private Map<String, ParameterBindingDTO> parameterBindings = new HashMap<String, ParameterBindingDTO>();
    private Map<String, ParameterBindingDTO> batchParameterBindings = new HashMap<String, ParameterBindingDTO>();
    private int batchSize = 0;
    private final Integer ERROR_CODE_TABLE_BIND_VARIABLE_NOT_SET = 2128;
    private final Integer ERROR_CODE_OBJECT_BIND_NOT_SET = 2129;
    private final Integer ERROR_CODE_STATEMENT_CANNOT_BE_PREPARED = 7;
    private final Set<Integer> errorCodesIgnoredInDescribeMode = new HashSet<Integer>(Arrays.asList(this.ERROR_CODE_TABLE_BIND_VARIABLE_NOT_SET, this.ERROR_CODE_STATEMENT_CANNOT_BE_PREPARED, this.ERROR_CODE_OBJECT_BIND_NOT_SET));

    SnowflakePreparedStatementV1(SnowflakeConnectionV1 connection, String sql) throws SQLException {
        super(connection);
        this.sql = sql;
        try {
            this.statementMetaData = this.sfStatement.describe(sql);
        }
        catch (SFException e) {
            throw new SnowflakeSQLException(e);
        }
        catch (SnowflakeSQLException e) {
            if (!this.errorCodesIgnoredInDescribeMode.contains(e.getErrorCode())) {
                throw e;
            }
            this.statementMetaData = SFStatementMetaData.emptyMetaData();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        logger.debug("executeQuery() throws SQLException");
        return this.executeQueryInternal(this.sql, this.parameterBindings);
    }

    @Override
    public int executeUpdate() throws SQLException {
        logger.debug("executeUpdate() throws SQLException");
        return this.executeUpdateInternal(this.sql, this.parameterBindings);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        logger.debug("setNull(int parameterIndex, int sqlType) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(sqlType), null);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        logger.debug("setBoolean(int parameterIndex, boolean x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(16), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("setByte(int parameterIndex, byte x) Not supported yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        logger.debug("setShort(int parameterIndex, short x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(5), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        logger.debug("setInt(int parameterIndex, int x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(4), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        logger.debug("setLong(int parameterIndex, long x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-5), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        logger.debug("setFloat(int parameterIndex, float x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(6), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        logger.debug("setDouble(int parameterIndex, double x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(8), String.valueOf(x));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        logger.debug("setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(3), String.valueOf(x));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        logger.debug("setString(int parameterIndex, String x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(12), x);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        logger.debug("setBytes(int parameterIndex, byte[] x) throws SQLException");
        ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(-2), new SFBinary(x).toHex());
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        logger.debug("setDate(int parameterIndex, Date x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(91), String.valueOf(x.getTime() + (long)TimeZone.getDefault().getOffset(x.getTime()) - ResultUtil.msDiffJulianToGregorian(x)));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        logger.debug("setTime(int parameterIndex, Time x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            long MS_IN_DAY = 86400000L;
            long msSinceEpoch = x.getTime();
            long msSinceMidnight = (msSinceEpoch % 86400000L + 86400000L) % 86400000L;
            long nanosSinceMidnight = msSinceMidnight * 1000L * 1000L;
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(92), String.valueOf(nanosSinceMidnight));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
            this.sfStatement.setHasUnsupportedStageBind(true);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        logger.debug("setTimestamp(int parameterIndex, Timestamp x) throws SQLException");
        String value = x == null ? null : String.valueOf(BigDecimal.valueOf((x.getTime() - ResultUtil.msDiffJulianToGregorian(x)) / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos())));
        SnowflakeType sfType = SnowflakeUtil.javaTypeToSFType(93);
        if (sfType == SnowflakeType.TIMESTAMP) {
            sfType = this.connection.getSfSession().getTimestampMappedType();
        }
        ParameterBindingDTO binding = new ParameterBindingDTO(sfType.name(), value);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setUnicodeStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterBindings.clear();
        if (this.batchParameterBindings.isEmpty()) {
            this.sfStatement.setHasUnsupportedStageBind(false);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        logger.debug("setObject(int parameterIndex, Object x, int targetSqlType)");
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 91) {
            this.setDate(parameterIndex, (Date)x);
        } else if (targetSqlType == 92) {
            this.setTime(parameterIndex, (Time)x);
        } else if (targetSqlType == 93) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(targetSqlType), String.valueOf(x));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SnowflakeSQLException("0A000", ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), "Object type: " + x.getClass());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        logger.debug("execute: {}", this.sql);
        return this.executeInternal(this.sql, this.parameterBindings);
    }

    @Override
    public void addBatch() throws SQLException {
        logger.debug("addBatch() throws SQLException");
        if (this.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
        if (this.statementMetaData.isArrayBindSupported()) {
            for (Map.Entry<String, ParameterBindingDTO> binding : this.parameterBindings.entrySet()) {
                List<String> values;
                ParameterBindingDTO bindingValueAndType = this.batchParameterBindings.get(binding.getKey());
                if (bindingValueAndType == null) {
                    values = new ArrayList<String>();
                    bindingValueAndType = new ParameterBindingDTO(binding.getValue().getType(), values);
                    this.batchParameterBindings.put(binding.getKey(), bindingValueAndType);
                } else {
                    String prevType = bindingValueAndType.getType();
                    String newType = binding.getValue().getType();
                    if (SnowflakeType.ANY.name().equalsIgnoreCase(prevType) && !SnowflakeType.ANY.name().equalsIgnoreCase(newType)) {
                        bindingValueAndType.setType(newType);
                    } else if (binding.getValue().getValue() != null && !prevType.equalsIgnoreCase(newType)) {
                        throw new SnowflakeSQLException("0A000", ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode(), SnowflakeType.getJavaType(SnowflakeType.fromString(prevType)).name(), SnowflakeType.getJavaType(SnowflakeType.fromString(newType)).name());
                    }
                    values = (List)bindingValueAndType.getValue();
                }
                values.add((String)binding.getValue().getValue());
            }
            ++this.batchSize;
        } else {
            this.batch.add(new SnowflakeStatementV1.BatchEntry(this, this.sql, this.parameterBindings));
            this.parameterBindings = new HashMap<String, ParameterBindingDTO>();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader, int length) Not supported yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("setRef(int parameterIndex, Ref x) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, Blob x) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Clob x) Not supported yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("setArray(int parameterIndex, Array x) Not supported yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("getMetaData() throws SQLException");
        return new SnowflakeResultSetMetaDataV1(this.statementMetaData.getResultSetMetaData());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        logger.debug("setDate(int parameterIndex, Date x, Calendar cal)");
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            String value = String.valueOf(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime()));
            ParameterBindingDTO binding = new ParameterBindingDTO(SnowflakeUtil.javaTypeToSFTypeString(91), value);
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        logger.debug("setTime(int parameterIndex, Time x, Calendar cal)");
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        SnowflakeType sfType;
        logger.debug("setTimestamp(int parameterIndex, Timestamp x, Calendar cal)");
        String value = null;
        if (x != null) {
            long milliSecSinceEpoch = x.getTime();
            milliSecSinceEpoch += (long)cal.getTimeZone().getOffset(milliSecSinceEpoch);
            value = String.valueOf(BigDecimal.valueOf(milliSecSinceEpoch / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos())));
        }
        if ((sfType = SnowflakeUtil.javaTypeToSFType(93)) == SnowflakeType.TIMESTAMP) {
            sfType = this.connection.getSfSession().getTimestampMappedType();
        }
        ParameterBindingDTO binding = new ParameterBindingDTO(sfType.name(), value);
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        logger.debug("setNull(int parameterIndex, int sqlType, String typeName)");
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("setURL(int parameterIndex, URL x) Not supported yet.");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData() Not supported yet.");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("setRowId(int parameterIndex, RowId x) Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("setNString(int parameterIndex, String value) Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("setNCharacterStream(int parameterIndex, Reader value, long length) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, NClob value) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, InputStream inputStream, long length) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("setSQLXML(int parameterIndex, SQLXML xmlObject) Not supported yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        logger.debug("setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength)");
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 3 || targetSqlType == 2) {
            BigDecimal decimalObj = new BigDecimal(String.valueOf(x));
            decimalObj.setScale(scaleOrLength);
            this.setBigDecimal(parameterIndex, decimalObj);
        } else {
            this.setObject(parameterIndex, x, targetSqlType);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x, long length) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x, long length) Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x) Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("setNCharacterStream(int parameterIndex, Reader value) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, InputStream inputStream) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        logger.debug("executeQuery(String sql) throws SQLException");
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        logger.debug("executeUpdate(String sql) throws SQLException");
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        logger.debug("execute(String sql) throws SQLException");
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, sql.length() > 20 ? sql.substring(0, 20) + "..." : sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchParameterBindings.clear();
        this.batchSize = 0;
        this.sfStatement.setHasUnsupportedStageBind(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        logger.debug("executeBatch() throws SQLException");
        if (this.statementMetaData.getStatementType().isGenerateResultSet()) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, this.sql.length() > 20 ? this.sql.substring(0, 20) + "..." : this.sql);
        }
        int[] updateCounts = null;
        try {
            if (this.statementMetaData.isArrayBindSupported()) {
                int updateCount = this.executeUpdateInternal(this.sql, this.batchParameterBindings);
                if (updateCount == this.batchSize) {
                    updateCounts = new int[updateCount];
                    for (int idx = 0; idx < updateCount; ++idx) {
                        updateCounts[idx] = 1;
                    }
                } else {
                    updateCounts = new int[]{updateCount};
                }
            } else {
                updateCounts = this.executeBatchInternal();
            }
        }
        finally {
            this.clearBatch();
        }
        return updateCounts;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, int autoGeneratedKeys) Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, int[] columnIndexes) Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, String[] columnNames) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, int autoGeneratedKeys) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, int[] columnIndexes) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, String[] columnNames) Not supported yet.");
    }

    Map<String, ParameterBindingDTO> getBatchParameterBindings() {
        return this.batchParameterBindings;
    }
}

