/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.waiters;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.util.ValidationUtils;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.WaiterAcceptor;
import net.snowflake.client.jdbc.internal.amazonaws.waiters.WaiterState;

@SdkInternalApi
class CompositeAcceptor<Output> {
    private List<WaiterAcceptor<Output>> acceptors = new ArrayList<WaiterAcceptor<Output>>();

    public CompositeAcceptor(List<WaiterAcceptor<Output>> acceptors) {
        this.acceptors = ValidationUtils.assertNotEmpty(acceptors, "acceptors");
    }

    public List<WaiterAcceptor<Output>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(Output response) {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(response)) continue;
            return acceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(AmazonServiceException exception) throws AmazonServiceException {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(exception)) continue;
            return acceptor.getState();
        }
        throw exception;
    }
}

