/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryV2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryV2.TelemetryEvent;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static ThreadLocal<TelemetryService> _threadLocal = new ThreadLocal<TelemetryService>(){

        @Override
        protected TelemetryService initialValue() {
            return new TelemetryService();
        }
    };
    private static HashSet<String> ENABLED_DEPLOYMENT = new HashSet<String>(Arrays.asList(TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.DEV), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.REG), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.QA1), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.PREPROD2)));
    private LinkedList<TelemetryEvent> queue = new LinkedList();
    private int BATCH_SIZE = 100;
    private TELEMETRY_SERVER_DEPLOYMENT serverDeployment;
    private boolean enabled = false;
    private JSONObject context;

    public static TelemetryService getInstance() {
        return _threadLocal.get();
    }

    private TelemetryService() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("shutdownHooks"));
            }
            Runtime.getRuntime().addShutdownHook(new TelemetryUploader(this));
        }
        catch (SecurityException e) {
            logger.debug("Failed to add shutdown hook for telemetry service");
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void updateContext(Map<String, String> params) {
        Properties info = new Properties();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null) continue;
            info.put(key, val);
        }
        this.updateContext(params.get("uri"), info);
    }

    public void updateContext(String url, Properties info) {
        this.configureDeployment(url, info.getProperty("account"), info.getProperty("port"));
        Enumeration<?> names = info.propertyNames();
        this.context = new JSONObject();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.compareTo("password") == 0 || name.compareTo("privateKey") == 0) continue;
            this.context.put(name, info.getProperty(name));
        }
    }

    private void configureDeployment(String url, String account, String port) {
        TELEMETRY_SERVER_DEPLOYMENT deployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
        if (url != null) {
            if (url.contains("reg") || url.contains("local")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.REG;
                if (port != null && port.compareTo("8080") == 0 || url.contains("8080")) {
                    deployment = TELEMETRY_SERVER_DEPLOYMENT.DEV;
                }
            } else if (url.contains("qa1") || account != null && account.contains("qa1")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
            } else if (url.contains("preprod2")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.PREPROD2;
            }
        }
        this.setDeployment(deployment);
    }

    public boolean isDeploymentEnabled() {
        return ENABLED_DEPLOYMENT.contains(this.serverDeployment.name);
    }

    public TelemetryEvent getEvent(int i) {
        if (this.queue != null && this.queue.size() > i && i >= 0) {
            return this.queue.get(i);
        }
        return null;
    }

    public void setDeployment(TELEMETRY_SERVER_DEPLOYMENT deployment) {
        this.serverDeployment = deployment;
    }

    public String getServerDeploymentName() {
        return this.serverDeployment.name;
    }

    public void add(TelemetryEvent event) {
        if (!this.enabled) {
            return;
        }
        this.queue.add(event);
        if (this.queue.size() >= this.BATCH_SIZE) {
            new TelemetryUploader(this).start();
        }
    }

    public void flush() {
        if (!this.enabled) {
            return;
        }
        if (!this.queue.isEmpty()) {
            new TelemetryUploader(this).start();
        }
    }

    public String logsToString(LinkedList<TelemetryEvent> queue) {
        JSONArray logs = new JSONArray();
        for (TelemetryEvent event : queue) {
            logs.add(event);
        }
        return logs.toString();
    }

    public int size() {
        return this.queue.size();
    }

    public void logHttpRequestError(HttpRequestBase request, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, CloseableHttpResponse response, Exception savedEx, String breakRetryReason, long retryTimeout, int retryCount, String sqlState, int errorCode) {
        if (this.enabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            JSONObject value = new JSONObject();
            String name = savedEx != null ? savedEx.getLocalizedMessage() : (response == null ? "null http response" : "http response with code " + response.getStatusLine().getStatusCode());
            value.put("request", request.toString());
            value.put("retryTimeout", retryTimeout);
            value.put("injectSocketTimeout", injectSocketTimeout);
            value.put("canceling", canceling == null ? "null" : Boolean.valueOf(canceling.get()));
            value.put("withoutCookies", withoutCookies);
            value.put("includeRetryParameters", includeRetryParameters);
            value.put("includeRequestGuid", includeRequestGuid);
            value.put("response", response);
            value.put("breakRetryReason", breakRetryReason);
            value.put("retryTimeout", retryTimeout);
            value.put("retryCount", retryCount);
            value.put("sqlState", sqlState);
            value.put("errorCode", errorCode);
            if (savedEx != null) {
                value.put("exceptionMessage", savedEx.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                value.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(name)).withValue(value).withTag("sqlState", sqlState)).withTag("errorCode", errorCode)).build();
            this.add(log);
        }
    }

    static class TelemetryUploader
    extends Thread {
        TelemetryService instance;

        public TelemetryUploader(TelemetryService _instance) {
            this.instance = _instance;
        }

        @Override
        public void run() {
            if (!this.instance.enabled) {
                return;
            }
            if (this.instance.queue.isEmpty()) {
                logger.debug("skip to run telemetry uploader for empty queue");
            } else {
                this.flushQueue();
                logger.debug("run telemetry uploader");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushQueue() {
            boolean success;
            HttpResponse response;
            block7: {
                response = null;
                success = true;
                if (this.instance.isDeploymentEnabled()) break block7;
                logger.debug("skip the disabled deployment: " + this.instance.serverDeployment.name);
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
                return;
            }
            try {
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.instance.serverDeployment.url);
                post.setEntity(new StringEntity(this.instance.logsToString(this.instance.queue)));
                post.setHeader("Content-type", "application/json");
                response = httpClient.execute(post);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    logger.debug("telemetry server request success: " + response);
                } else {
                    logger.debug("telemetry server request error: " + response);
                    success = false;
                }
                logger.debug(EntityUtils.toString(response.getEntity(), "UTF-8"));
            }
            catch (IOException e) {
                try {
                    logger.debug("Telemetry request failed, IOExceptionresponse: {}, exception: {}", response, e.getMessage());
                    success = false;
                }
                catch (Throwable throwable) {
                    logger.debug("Telemetry request success={} and clean the current queue", success);
                    this.instance.queue.clear();
                    throw throwable;
                }
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
            }
            logger.debug("Telemetry request success={} and clean the current queue", success);
            this.instance.queue.clear();
        }
    }

    public static enum TELEMETRY_SERVER_DEPLOYMENT {
        DEV("dev", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCTEST)),
        REG("reg", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCTEST)),
        QA1("qa1", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCDEV)),
        PREPROD2("preprod2", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCDEV)),
        PROD("prod", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.US2)),
        NONEXISTENT("nonexistent", "https://nonexist.execute-api.us-west-2.amazonaws.com/sfctest/enqueue");

        private final String name;
        private final String url;

        private TELEMETRY_SERVER_DEPLOYMENT(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum TELEMETRY_SERVER_URL {
        SFCTEST("https://lximwp8945.execute-api.us-west-2.amazonaws.com/sfctest/enqueue"),
        SFCDEV("https://lol6l3j52m.execute-api.us-west-2.amazonaws.com/sfcdev/enqueue"),
        US2("https://lol6l3j52m.execute-api.us-west-2.amazonaws.com/sfctest/enqueue");

        private final String url;

        private TELEMETRY_SERVER_URL(String url) {
            this.url = url;
        }

        static /* synthetic */ String access$200(TELEMETRY_SERVER_URL x0) {
            return x0.url;
        }
    }
}

