/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3;

import net.snowflake.client.jdbc.internal.amazonaws.ClientConfigurationFactory;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.NotThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.client.AwsSyncClientParams;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkFunction;
import net.snowflake.client.jdbc.internal.amazonaws.regions.AwsRegionProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Builder;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3ClientParamsWrapper;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.S3CredentialsProviderChain;

@NotThreadSafe
public final class AmazonS3ClientBuilder
extends AmazonS3Builder<AmazonS3ClientBuilder, AmazonS3> {
    private AmazonS3ClientBuilder() {
    }

    @SdkTestInternalApi
    AmazonS3ClientBuilder(SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory, ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        super(clientFactory, clientConfigFactory, regionProvider);
    }

    public static AmazonS3ClientBuilder standard() {
        return (AmazonS3ClientBuilder)new AmazonS3ClientBuilder().withCredentials(new S3CredentialsProviderChain());
    }

    public static AmazonS3 defaultClient() {
        return (AmazonS3)AmazonS3ClientBuilder.standard().build();
    }

    @Override
    protected AmazonS3 build(AwsSyncClientParams clientParams) {
        return (AmazonS3)this.clientFactory.apply(new AmazonS3ClientParamsWrapper(clientParams, this.resolveS3ClientOptions()));
    }
}

