/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform;

import javax.xml.stream.events.XMLEvent;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ServerSideEncryptionByDefault;
import net.snowflake.client.jdbc.internal.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import net.snowflake.client.jdbc.internal.amazonaws.transform.StaxUnmarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;

class ServerSideEncryptionByDefaultStaxUnmarshaller
implements Unmarshaller<ServerSideEncryptionByDefault, StaxUnmarshallerContext> {
    private static final ServerSideEncryptionByDefaultStaxUnmarshaller instance = new ServerSideEncryptionByDefaultStaxUnmarshaller();

    public static ServerSideEncryptionByDefaultStaxUnmarshaller getInstance() {
        return instance;
    }

    private ServerSideEncryptionByDefaultStaxUnmarshaller() {
    }

    @Override
    public ServerSideEncryptionByDefault unmarshall(StaxUnmarshallerContext context) throws Exception {
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        ServerSideEncryptionByDefault sseByDefault = new ServerSideEncryptionByDefault();
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sseByDefault;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SSEAlgorithm", targetDepth)) {
                    sseByDefault.setSSEAlgorithm(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                }
                if (!context.testExpression("KMSMasterKeyID", targetDepth)) continue;
                sseByDefault.setKMSMasterKeyID(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sseByDefault;
    }
}

