/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.security.PrivateKey;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.snowflake.client.core.HeartbeatBackground;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFSession {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFSession.class);
    private static final String SF_PATH_SESSION_HEARTBEAT = "/session/heartbeat";
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    private static int SF_HEARTBEAT_TIMEOUT = 300;
    private HttpClient httpClient;
    private boolean isClosed = true;
    private String sessionToken;
    private String masterToken;
    private long masterTokenValidityInSeconds;
    private String newClientForUpdate;
    private AtomicInteger _injectedDelay = new AtomicInteger(0);
    private String databaseVersion = null;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private AtomicInteger sequenceId = new AtomicInteger(0);
    private int loginTimeout = 60;
    private int networkTimeoutInMilli = 0;
    private boolean enableCombineDescribe = false;
    private Map<String, Object> sessionProperties = new HashMap<String, Object>(1);
    private static final ObjectMapper mapper = new ObjectMapper();
    private Properties clientInfo = new Properties();
    private int healthCheckInterval = 45;
    private int httpClientConnectionTimeout = 60000;
    private static int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private int httpClientSocketTimeout = DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT;
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private String injectFileUploadFailure = null;
    private Map<SFSessionProperty, Object> connectionPropertiesMap = new HashMap<SFSessionProperty, Object>();
    private Map<String, Object> sessionParametersMap = new HashMap<String, Object>();
    private static final int MAX_SESSION_PARAMETERS = 1000;
    private boolean passcodeInPassword = false;
    private boolean executeReturnCountForDML = false;
    private boolean enableHeartbeat = false;
    private AtomicBoolean autoCommit = new AtomicBoolean(true);
    private boolean rsColumnCaseInsensitive = false;
    private String database;
    private String schema;
    private String role;
    private boolean metadataRequestUseConnectionCtx = false;
    private SnowflakeType timestampMappedType = SnowflakeType.TIMESTAMP_LTZ;
    private boolean jdbcTreatDecimalAsInt = true;
    private Level tracingLevel = Level.INFO;
    private List<SFException> sqlWarnings = new ArrayList<SFException>();
    private Telemetry telemetryClient;

    public void addProperty(SFSessionProperty sfSessionProperty, Object propertyValue) throws SFException {
        this.addProperty(sfSessionProperty.getPropertyKey(), propertyValue);
    }

    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        block18: {
            block17: {
                SFSessionProperty connectionProperty = SFSessionProperty.lookupByKey(propertyName);
                if (connectionProperty == null) break block17;
                propertyValue = SFSessionProperty.checkPropertyValue(connectionProperty, propertyValue);
                if (this.connectionPropertiesMap.containsKey((Object)connectionProperty)) {
                    throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
                }
                this.connectionPropertiesMap.put(connectionProperty, propertyValue);
                switch (connectionProperty) {
                    case LOGIN_TIMEOUT: {
                        if (propertyValue != null) {
                            this.loginTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block18;
                    }
                    case NETWORK_TIMEOUT: {
                        if (propertyValue != null) {
                            this.networkTimeoutInMilli = (Integer)propertyValue;
                            break;
                        }
                        break block18;
                    }
                    case INJECT_CLIENT_PAUSE: {
                        if (propertyValue != null) {
                            this.injectClientPause = (Integer)propertyValue;
                            break;
                        }
                        break block18;
                    }
                    case INJECT_SOCKET_TIMEOUT: {
                        if (propertyValue != null) {
                            this.injectSocketTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block18;
                    }
                    case PASSCODE_IN_PASSWORD: {
                        this.passcodeInPassword = propertyValue != null && (Boolean)propertyValue != false;
                        break;
                    }
                    case TRACING: {
                        if (propertyValue != null) {
                            this.tracingLevel = Level.parse(((String)propertyValue).toUpperCase());
                            if (this.tracingLevel != null && System.getProperty("snowflake.jdbc.loggerImpl") == null && logger instanceof JDK14Logger) {
                                JDK14Logger.setLevel(this.tracingLevel);
                                break;
                            }
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (this.sessionParametersMap.containsKey(propertyName)) {
                throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
            }
            this.sessionParametersMap.put(propertyName, propertyValue);
            if (this.sessionParametersMap.size() > 1000) {
                throw new SFException(ErrorCode.TOO_MANY_SESSION_PARAMETERS, 1000);
            }
        }
    }

    protected String getServerUrl() {
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.SERVER_URL)) {
            return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL);
        }
        return null;
    }

    private boolean isSnowflakeAuthenticator() {
        String authenticator = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        PrivateKey privateKey = (PrivateKey)this.connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY);
        return authenticator == null && privateKey == null || ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name().equalsIgnoreCase(authenticator);
    }

    public synchronized void open() throws SFException, SnowflakeSQLException {
        this.performSanityCheckOnProperties();
        if (this.httpClient == null) {
            Boolean insecureMode = (Boolean)this.connectionPropertiesMap.get((Object)SFSessionProperty.INSECURE_MODE);
            this.httpClient = HttpUtil.getHttpClient(insecureMode != null ? insecureMode : false, null);
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setDatabaseName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE)).setSchemaName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA)).setWarehouse((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE)).setRole((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.ROLE)).setAuthenticator((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR)).setHttpClient(this.httpClient).setAccountName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT)).setLoginTimeout(this.loginTimeout).setUserName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER)).setPassword((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)).setToken((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.TOKEN)).setClientInfo(this.getClientInfo()).setPasscodeInPassword(this.passcodeInPassword).setPasscode((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)).setConnectionTimeout(this.httpClientConnectionTimeout).setSocketTimeout(this.httpClientSocketTimeout).setAppId((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID)).setAppVersion((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION)).setSessionParameters(this.sessionParametersMap).setPrivateKey((PrivateKey)this.connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY)).setApplication((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APPLICATION));
        SessionUtil.LoginOutput loginOutput = SessionUtil.openSession(loginInput);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
        this.databaseVersion = loginOutput.getDatabaseVersion();
        this.databaseMajorVersion = loginOutput.getDatabaseMajorVersion();
        this.databaseMinorVersion = loginOutput.getDatabaseMinorVersion();
        this.healthCheckInterval = loginOutput.getHealthCheckInterval();
        this.httpClientSocketTimeout = loginOutput.getHttpClientSocketTimeout();
        this.masterTokenValidityInSeconds = loginOutput.getMasterTokenValidityInSeconds();
        this.database = loginOutput.getSessionDatabase();
        this.schema = loginOutput.getSessionSchema();
        this.role = loginOutput.getSessionRole();
        SessionUtil.updateSfDriverParamValues(loginOutput.getCommonParams(), this);
        String loginDatabaseName = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE);
        String loginSchemaName = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA);
        String loginRole = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.ROLE);
        if (loginDatabaseName != null && !loginDatabaseName.equalsIgnoreCase(this.database)) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Database", loginDatabaseName, this.database));
        }
        if (loginSchemaName != null && !loginSchemaName.equalsIgnoreCase(this.schema)) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Schema", loginSchemaName, this.schema));
        }
        if (loginRole != null && !loginRole.equalsIgnoreCase(this.role)) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Role", loginRole, this.role));
        }
        this.startHeartbeatForThisSession();
        this.isClosed = false;
    }

    private void performSanityCheckOnProperties() throws SFException {
        block5: for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || this.connectionPropertiesMap.containsKey((Object)property)) continue;
            switch (property) {
                case SERVER_URL: {
                    throw new SFException(ErrorCode.MISSING_SERVER_URL, new Object[0]);
                }
                case USER: {
                    throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
                }
                case PASSWORD: {
                    if (!this.isSnowflakeAuthenticator()) continue block5;
                    throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
                }
                default: {
                    throw new SFException(ErrorCode.MISSING_CONNECTION_PROPERTY, property.getPropertyKey());
                }
            }
        }
        String userName = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER);
        if (userName == null || userName.isEmpty()) {
            throw new SFException(ErrorCode.MISSING_USERNAME, new Object[0]);
        }
        String password = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD);
        if (this.isSnowflakeAuthenticator() && (password == null || password.isEmpty())) {
            throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getNewClientForUpdate() {
        return this.newClientForUpdate;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    private void setNewClientForUpdate(String newClientForUpdate) {
        this.newClientForUpdate = newClientForUpdate;
    }

    synchronized void renewSession(String prevSessionToken) throws SFException, SnowflakeSQLException {
        if (this.sessionToken != null && !this.sessionToken.equals(prevSessionToken)) {
            return;
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setSessionToken(this.sessionToken).setMasterToken(this.masterToken).setHttpClient(this.httpClient).setLoginTimeout(this.loginTimeout);
        SessionUtil.LoginOutput loginOutput = SessionUtil.renewSession(loginInput);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void close() throws SFException, SnowflakeSQLException {
        logger.debug(" public void close() throws SFException");
        this.stopHeartbeatForThisSession();
        if (this.isClosed) {
            return;
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setSessionToken(this.sessionToken).setHttpClient(this.httpClient).setLoginTimeout(this.loginTimeout);
        try {
            SessionUtil.closeSession(loginInput);
            this.closeTelemetryClient();
            this.isClosed = true;
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient = null;
            }
        }
    }

    protected void startHeartbeatForThisSession() {
        if (this.enableHeartbeat) {
            logger.debug("start heartbeat, master token validity: " + this.masterTokenValidityInSeconds);
            HeartbeatBackground.getInstance().addSession(this, this.masterTokenValidityInSeconds);
        } else {
            logger.debug("heartbeat not enabled for the session");
        }
    }

    protected void stopHeartbeatForThisSession() {
        if (this.enableHeartbeat) {
            logger.debug("stop heartbeat");
            HeartbeatBackground.getInstance().removeSession(this);
        } else {
            logger.debug("heartbeat not enabled for the session");
        }
    }

    protected void heartbeat() throws SFException, SQLException {
        logger.debug(" public void heartbeat()");
        if (this.isClosed) {
            return;
        }
        HttpPost postRequest = null;
        String requestId = UUID.randomUUID().toString();
        boolean retry = false;
        do {
            try {
                URIBuilder uriBuilder = new URIBuilder((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL));
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, requestId);
                uriBuilder.setPath(SF_PATH_SESSION_HEARTBEAT);
                postRequest = new HttpPost(uriBuilder.build());
                String prevSessionToken = this.sessionToken;
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + prevSessionToken + "\"");
                logger.debug("Executing heartbeat request: {}", postRequest.toString());
                String theResponse = HttpUtil.executeRequest(postRequest, this.httpClient, SF_HEARTBEAT_TIMEOUT, 0, null);
                logger.debug("connection heartbeat response: {}", theResponse);
                JsonNode rootNode = mapper.readTree(theResponse);
                if (rootNode != null && 390112 == rootNode.path("code").asInt()) {
                    logger.debug("renew session and retry");
                    this.renewSession(prevSessionToken);
                    retry = true;
                    continue;
                }
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
                retry = false;
            }
            catch (Throwable ex) {
                if (ex instanceof SnowflakeSQLException) {
                    throw (SnowflakeSQLException)ex;
                }
                logger.error("unexpected exception", ex);
                SFException sfe = IncidentUtil.generateIncidentWithException(this, requestId, null, ex, ErrorCode.INTERNAL_ERROR, "unexpected exception: " + ex.getMessage());
                throw sfe;
            }
        } while (retry);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.debug(" public void setClientInfo(Properties properties)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.debug(" public void setClientInfo(String name, String value)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.setProperty(name, value);
    }

    public Properties getClientInfo() {
        logger.debug(" public Properties getClientInfo()");
        if (this.clientInfo != null) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)this.clientInfo);
            return copy;
        }
        return null;
    }

    public String getClientInfo(String name) {
        logger.debug(" public String getClientInfo(String name)");
        if (this.clientInfo != null) {
            return this.clientInfo.getProperty(name);
        }
        return null;
    }

    void setSFSessionProperty(String propertyName, boolean propertyValue) {
        this.sessionProperties.put(propertyName, propertyValue);
    }

    public Object getSFSessionProperty(String propertyName) {
        return this.sessionProperties.get(propertyName);
    }

    public void setInjectedDelay(int delay) {
        this._injectedDelay.set(delay);
    }

    void injectedDelay() {
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
    }

    public void setInjectFileUploadFailure(String fileToFail) {
        this.injectFileUploadFailure = fileToFail;
    }

    public String getInjectFileUploadFailure() {
        return this.injectFileUploadFailure;
    }

    protected int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getInjectClientPause() {
        return this.injectClientPause;
    }

    public void setInjectClientPause(int injectClientPause) {
        this.injectClientPause = injectClientPause;
    }

    protected int getHttpClientConnectionTimeout() {
        return this.httpClientConnectionTimeout;
    }

    protected int getHttpClientSocketTimeout() {
        return this.httpClientSocketTimeout;
    }

    protected int getAndIncrementSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    public void setExecuteReturnCountForDML(boolean executeReturnCountForDML) {
        this.executeReturnCountForDML = executeReturnCountForDML;
    }

    public boolean isExecuteReturnCountForDML() {
        return this.executeReturnCountForDML;
    }

    public boolean isEnableHeartbeat() {
        return this.enableHeartbeat;
    }

    public void setEnableHeartbeat(boolean enableHeartbeat) {
        this.enableHeartbeat = enableHeartbeat;
    }

    public boolean getAutoCommit() {
        return this.autoCommit.get();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit.set(autoCommit);
    }

    public void setRsColumnCaseInsensitive(boolean rsColumnCaseInsensitive) {
        this.rsColumnCaseInsensitive = rsColumnCaseInsensitive;
    }

    public boolean getRsColumnCaseInsensitive() {
        return this.rsColumnCaseInsensitive;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setMetadataRequestUseConnectionCtx(boolean enabled) {
        this.metadataRequestUseConnectionCtx = enabled;
    }

    public boolean getMetadataRequestUseConnectionCtx() {
        return this.metadataRequestUseConnectionCtx;
    }

    public SnowflakeType getTimestampMappedType() {
        return this.timestampMappedType;
    }

    public void setTimestampMappedType(SnowflakeType timestampMappedType) {
        this.timestampMappedType = timestampMappedType;
    }

    public boolean isJdbcTreatDecimalAsInt() {
        return this.jdbcTreatDecimalAsInt;
    }

    public void setJdbcTreatDecimalAsInt(boolean jdbcTreatDecimalAsInt) {
        this.jdbcTreatDecimalAsInt = jdbcTreatDecimalAsInt;
    }

    public void setEnableCombineDescribe(boolean enable) {
        this.enableCombineDescribe = enable;
    }

    public boolean getEnableCombineDescribe() {
        return this.enableCombineDescribe;
    }

    public Integer getQueryTimeout() {
        return (Integer)this.connectionPropertiesMap.get((Object)SFSessionProperty.QUERY_TIMEOUT);
    }

    public String getUser() {
        return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER);
    }

    public String getUrl() {
        return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL);
    }

    public List<SFException> getSqlWarnings() {
        return this.sqlWarnings;
    }

    public void clearSqlWarnings() {
        this.sqlWarnings.clear();
    }

    public synchronized Telemetry getTelemetryClient() {
        if (this.telemetryClient == null) {
            if (this.getUrl() == null) {
                logger.error("Telemetry client created before session properties set.");
                return null;
            }
            this.telemetryClient = Telemetry.createTelemetry(this);
        }
        return this.telemetryClient;
    }

    public void closeTelemetryClient() {
        if (this.telemetryClient != null) {
            try {
                this.telemetryClient.close();
            }
            catch (IOException ex) {
                logger.warn("Telemetry client failed to submit metrics on close.");
            }
        }
    }
}

