/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jwt;

import java.text.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEObject;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Payload;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.PlainHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.PlainObject;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@ThreadSafe
public class PlainJWT
extends PlainObject
implements JWT {
    private static final long serialVersionUID = 1L;

    public PlainJWT(JWTClaimsSet claimsSet) {
        super(new Payload(claimsSet.toJSONObject()));
    }

    public PlainJWT(PlainHeader header, JWTClaimsSet claimsSet) {
        super(header, new Payload(claimsSet.toJSONObject()));
    }

    public PlainJWT(Base64URL firstPart, Base64URL secondPart) throws ParseException {
        super(firstPart, secondPart);
    }

    @Override
    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        JSONObject json = this.getPayload().toJSONObject();
        if (json == null) {
            throw new ParseException("Payload of unsecured JOSE object is not a valid JSON object", 0);
        }
        return JWTClaimsSet.parse(json);
    }

    public static PlainJWT parse(String s) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s);
        if (!parts[2].toString().isEmpty()) {
            throw new ParseException("Unexpected third Base64URL part in the unsecured JWT object", 0);
        }
        return new PlainJWT(parts[0], parts[1]);
    }

    public static /* bridge */ /* synthetic */ PlainObject parse(String string) throws ParseException {
        return PlainJWT.parse(string);
    }
}

