/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.regions;

import java.io.File;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.AllProfiles;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfile;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import net.snowflake.client.jdbc.internal.amazonaws.profile.path.AwsProfileFileLocationProvider;
import net.snowflake.client.jdbc.internal.amazonaws.regions.AwsRegionProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

public class AwsProfileRegionProvider
extends AwsRegionProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileRegionProvider() {
        this(AwsProfileNameLoader.INSTANCE.loadProfileName());
    }

    public AwsProfileRegionProvider(String profileName) {
        this(profileName, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileRegionProvider(String profileName, AwsProfileFileLocationProvider locationProvider, BasicProfileConfigLoader configLoader) {
        this.profileName = profileName;
        this.locationProvider = locationProvider;
        this.profileConfigLoader = configLoader;
    }

    @Override
    public String getRegion() throws SdkClientException {
        BasicProfile profile;
        File configFile = this.locationProvider.getLocation();
        if (configFile != null && configFile.exists() && (profile = this.loadProfile(configFile)) != null && !StringUtils.isNullOrEmpty(profile.getRegion())) {
            return profile.getRegion();
        }
        return null;
    }

    private BasicProfile loadProfile(File configFile) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(configFile);
        return allProfiles.getProfile(this.profileName);
    }
}

