/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;

class SnowflakeResultSetV1
extends SnowflakeBaseResultSet {
    private SFBaseResultSet sfBaseResultSet;
    private Statement statement;

    SnowflakeResultSetV1(SFBaseResultSet sfBaseResultSet, Statement statement) throws SQLException {
        this.sfBaseResultSet = sfBaseResultSet;
        this.statement = statement;
        try {
            this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfBaseResultSet.getMetaData());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.sfBaseResultSet.next();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void close() throws SQLException {
        this.sfBaseResultSet.close();
    }

    @Override
    public boolean wasNull() {
        return this.sfBaseResultSet.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getString(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getBoolean(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getShort(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getInt(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getLong(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getFloat(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getDouble(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        try {
            return this.sfBaseResultSet.getDate(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getTime(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        try {
            return this.sfBaseResultSet.getTimestamp(columnIndex, tz);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("public ResultSetMetaData getMetaData()");
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getObject(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getBigDecimal(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            return this.sfBaseResultSet.getBigDecimal(columnIndex, scale);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this.sfBaseResultSet.getBytes(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public int getRow() throws SQLException {
        logger.debug("public int getRow()");
        return this.sfBaseResultSet.getRow();
    }

    @Override
    public boolean isFirst() throws SQLException {
        logger.debug("public boolean isFirst()");
        return this.sfBaseResultSet.isFirst();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.sfBaseResultSet.isClosed();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.sfBaseResultSet.isLast();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.sfBaseResultSet.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.sfBaseResultSet.isBeforeFirst();
    }
}

