/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk;

import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWK;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKMatcher;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKSet;

@Immutable
public final class JWKSelector {
    private final JWKMatcher matcher;

    public JWKSelector(JWKMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("The JWK matcher must not be null");
        }
        this.matcher = matcher;
    }

    public JWKMatcher getMatcher() {
        return this.matcher;
    }

    public List<JWK> select(JWKSet jwkSet) {
        LinkedList<JWK> selectedKeys = new LinkedList<JWK>();
        if (jwkSet == null) {
            return selectedKeys;
        }
        for (JWK key : jwkSet.getKeys()) {
            if (!this.matcher.matches(key)) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }
}

