/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.util.LinkedList;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class AWSCredentialsProviderChain
implements AWSCredentialsProvider {
    private static final Log log = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AWSCredentialsProvider> credentialsProviders = new LinkedList<AWSCredentialsProvider>();
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastUsedProvider;

    public AWSCredentialsProviderChain(List<? extends AWSCredentialsProvider> credentialsProviders) {
        if (credentialsProviders == null || credentialsProviders.size() == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        this.credentialsProviders.addAll(credentialsProviders);
    }

    public AWSCredentialsProviderChain(AWSCredentialsProvider ... credentialsProviders) {
        if (credentialsProviders == null || credentialsProviders.length == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        for (AWSCredentialsProvider provider : credentialsProviders) {
            this.credentialsProviders.add(provider);
        }
    }

    public boolean getReuseLastProvider() {
        return this.reuseLastProvider;
    }

    public void setReuseLastProvider(boolean b) {
        this.reuseLastProvider = b;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.reuseLastProvider && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        for (AWSCredentialsProvider provider : this.credentialsProviders) {
            try {
                AWSCredentials credentials = provider.getCredentials();
                if (credentials.getAWSAccessKeyId() == null || credentials.getAWSSecretKey() == null) continue;
                log.debug("Loading credentials from " + provider.toString());
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (Exception e) {
                log.debug("Unable to load credentials from " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new SdkClientException("Unable to load AWS credentials from any provider in the chain");
    }

    @Override
    public void refresh() {
        for (AWSCredentialsProvider provider : this.credentialsProviders) {
            provider.refresh();
        }
    }
}

