/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.jsoup.parser;

import net.snowflake.client.jdbc.internal.org.jsoup.helper.DescendableLinkedList;
import net.snowflake.client.jdbc.internal.org.jsoup.helper.Validate;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Document;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Element;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.CharacterReader;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.ParseErrorList;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.Token;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected DescendableLinkedList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;

    TreeBuilder() {
    }

    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new DescendableLinkedList();
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected Element currentElement() {
        return (Element)this.stack.getLast();
    }
}

