/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.model;

import java.io.Serializable;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ExtraMaterialsDescription;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.GetObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectId;

public class EncryptedGetObjectRequest
extends GetObjectRequest
implements Serializable {
    private ExtraMaterialsDescription supplemental = ExtraMaterialsDescription.NONE;
    private String instructionFileSuffix;
    private boolean keyWrapExpected;

    public EncryptedGetObjectRequest(String bucketName, String key) {
        this(bucketName, key, null);
    }

    public EncryptedGetObjectRequest(String bucketName, String key, String versionId) {
        super(bucketName, key, versionId);
        this.setKey(key);
        this.setVersionId(versionId);
    }

    public EncryptedGetObjectRequest(S3ObjectId s3ObjectId) {
        super(s3ObjectId);
    }

    public EncryptedGetObjectRequest(String bucketName, String key, boolean isRequesterPays) {
        super(bucketName, key, isRequesterPays);
    }

    public ExtraMaterialsDescription getExtraMaterialDescription() {
        return this.supplemental;
    }

    public void setExtraMaterialDescription(ExtraMaterialsDescription supplemental) {
        this.supplemental = supplemental == null ? ExtraMaterialsDescription.NONE : supplemental;
    }

    public EncryptedGetObjectRequest withExtraMaterialsDescription(ExtraMaterialsDescription supplemental) {
        this.setExtraMaterialDescription(supplemental);
        return this;
    }

    public EncryptedGetObjectRequest withExtraMaterialsDescription(Map<String, String> supplemental) {
        this.setExtraMaterialDescription(supplemental == null ? null : new ExtraMaterialsDescription(supplemental));
        return this;
    }

    public String getInstructionFileSuffix() {
        return this.instructionFileSuffix;
    }

    public void setInstructionFileSuffix(String instructionFileSuffix) {
        this.instructionFileSuffix = instructionFileSuffix;
    }

    public EncryptedGetObjectRequest withInstructionFileSuffix(String instructionFileSuffix) {
        this.instructionFileSuffix = instructionFileSuffix;
        return this;
    }

    public boolean isKeyWrapExpected() {
        return this.keyWrapExpected;
    }

    public void setKeyWrapExpected(boolean keyWrapExpected) {
        this.keyWrapExpected = keyWrapExpected;
    }

    public EncryptedGetObjectRequest withKeyWrapExpected(boolean keyWrapExpected) {
        this.keyWrapExpected = keyWrapExpected;
        return this;
    }
}

