/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class TimeUtil {
    private static final BigDecimal LONG_MIN_VALUE_BIGD = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE_BIGD = BigDecimal.valueOf(Long.MAX_VALUE);
    private static TimeZone utcTZ = TimeZone.getTimeZone("UTC");

    public static Timestamp timestampFromNs(BigDecimal ns) {
        BigDecimal nsIntegral = ns.scaleByPowerOfTen(-9).setScale(0, RoundingMode.FLOOR).scaleByPowerOfTen(9);
        BigDecimal msIntegral = nsIntegral.scaleByPowerOfTen(-6);
        BigDecimal nsFractional = ns.subtract(nsIntegral);
        if (msIntegral.compareTo(LONG_MIN_VALUE_BIGD) < 0 || msIntegral.compareTo(LONG_MAX_VALUE_BIGD) > 0) {
            return null;
        }
        Timestamp ts = new Timestamp(msIntegral.longValueExact());
        long millisToAdjust = TimeUtil.msDiffJulianToGregorian(ts);
        Timestamp adjustedTs = new Timestamp(ts.getTime() + millisToAdjust);
        adjustedTs.setNanos(nsFractional.intValueExact());
        return adjustedTs;
    }

    public static long msDiffJulianToGregorian(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        if (date.getTime() < -12220156800000L) {
            if (month == 0 || month == 1 && dayOfMonth <= 28) {
                --year;
            }
            int hundreds = year / 100;
            int differenceInDays = hundreds - hundreds / 4 - 2;
            return differenceInDays * 86400000;
        }
        return 0L;
    }

    public static SFTimestamp getSFTimestamp(String timestampStr, int scale, TimestampType internalColumnType, long resultVersion, TimeZone sessionTZ) throws IllegalArgumentException {
        return TimeUtil.getSFTimestamp(timestampStr, TimestampUnit.IN_SECONDS, scale, internalColumnType, resultVersion, sessionTZ);
    }

    public static SFTimestamp getSFTimestamp(String timestampStr, TimestampUnit unit, int scale, TimestampType internalColumnType, long resultVersion, TimeZone sessionTZ) throws IllegalArgumentException {
        assert (unit == TimestampUnit.IN_NANOSECONDS && scale == 0 || unit == TimestampUnit.IN_SECONDS && scale >= 0);
        try {
            TimeZone tz;
            BigDecimal fractionsSinceEpoch;
            switch (internalColumnType) {
                case TIMESTAMP_NTZ: {
                    fractionsSinceEpoch = TimeUtil.parseSecondsSinceEpoch(timestampStr, scale);
                    tz = utcTZ;
                    break;
                }
                case TIMESTAMP_TZ: {
                    if (resultVersion > 0L) {
                        int indexForSeparator = timestampStr.indexOf(32);
                        String secondsSinceEpochStr = timestampStr.substring(0, indexForSeparator);
                        String timezoneIndexStr = timestampStr.substring(indexForSeparator + 1);
                        fractionsSinceEpoch = TimeUtil.parseSecondsSinceEpoch(secondsSinceEpochStr, scale);
                        tz = SFTimestamp.convertTimezoneIndexToTimeZone(Integer.parseInt(timezoneIndexStr));
                        break;
                    }
                    fractionsSinceEpoch = TimeUtil.parseSecondsSinceEpoch(timestampStr, scale);
                    tz = null;
                    break;
                }
                default: {
                    assert (internalColumnType == TimestampType.TIMESTAMP_LTZ);
                    fractionsSinceEpoch = TimeUtil.parseSecondsSinceEpoch(timestampStr, scale);
                    tz = sessionTZ;
                }
            }
            if (unit == TimestampUnit.IN_SECONDS) {
                return SFTimestamp.fromBinary(fractionsSinceEpoch, scale, tz);
            }
            return SFTimestamp.fromNanoseconds(fractionsSinceEpoch, tz);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static SFTime getSFTime(String obj, int scale) throws IllegalArgumentException {
        try {
            long fractionsSinceMidnight = TimeUtil.parseSecondsSinceEpoch(obj, scale).longValue();
            return SFTime.fromFractionalSeconds(fractionsSinceMidnight, scale);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private static BigDecimal parseSecondsSinceEpoch(String secondsSinceEpochStr, int scale) {
        BigDecimal secondsSinceEpoch = new BigDecimal(secondsSinceEpochStr);
        return secondsSinceEpoch.scaleByPowerOfTen(scale);
    }

    public static enum TimestampUnit {
        IN_NANOSECONDS,
        IN_SECONDS;

    }

    public static enum TimestampType {
        TIMESTAMP_NTZ,
        TIMESTAMP_TZ,
        TIMESTAMP_LTZ;

    }
}

