/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.AzureObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.StringUtils;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.ImmutablePair;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.Pair;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsAnonymous;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobContainer;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlockBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.ListBlobItem;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeAzureClient
implements SnowflakeStorageClient {
    private static final String localFileSep = System.getProperty("file.separator");
    private static final String AZ_ENCRYPTIONDATAPROP = "encryptiondata";
    private int encryptionKeySize = 0;
    private StageInfo stageInfo;
    private RemoteStoreFileEncryptionMaterial encMat;
    private CloudBlobClient azStorageClient;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);

    private SnowflakeAzureClient() {
    }

    public static SnowflakeAzureClient createSnowflakeAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat) throws SnowflakeSQLException {
        SnowflakeAzureClient azureClient = new SnowflakeAzureClient();
        azureClient.setupAzureClient(stage, encMat);
        return azureClient;
    }

    private void setupAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat) throws IllegalArgumentException, SnowflakeSQLException {
        this.stageInfo = stage;
        this.encMat = encMat;
        logger.debug("Setting up the Azure client ");
        try {
            URI storageEndpoint = SnowflakeAzureClient.buildAzureStorageEndpointURI(stage.getEndPoint(), stage.getStorageAccount());
            String sasToken = (String)stage.getCredentials().get("AZURE_SAS_TOKEN");
            StorageCredentials azCreds = sasToken != null ? new StorageCredentialsSharedAccessSignature(sasToken) : StorageCredentialsAnonymous.ANONYMOUS;
            if (encMat != null) {
                byte[] decodedKey = Base64.decode(encMat.getQueryStageMasterKey());
                this.encryptionKeySize = decodedKey.length * 8;
                if (this.encryptionKeySize != 128 && this.encryptionKeySize != 192 && this.encryptionKeySize != 256) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "unsupported key size", this.encryptionKeySize);
                }
            }
            this.azStorageClient = new CloudBlobClient(storageEndpoint, azCreds);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid_azure_credentials");
        }
    }

    @Override
    public int getMaxRetries() {
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0;
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public void renew(Map stageCredentials) throws SnowflakeSQLException {
        this.stageInfo.setCredentials(stageCredentials);
        this.setupAzureClient(this.stageInfo, this.encMat);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        StorageObjectSummaryCollection storageObjectSummaries;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            Iterable<ListBlobItem> listBlobItemIterable = container.listBlobs(prefix, true);
            storageObjectSummaries = new StorageObjectSummaryCollection(listBlobItemIterable);
        }
        catch (URISyntaxException | StorageException ex) {
            logger.debug("Failed to list objects: {}", ex);
            throw new StorageProviderException(ex);
        }
        return storageObjectSummaries;
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        AzureObjectMetadata azureObjectMetadata = null;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            CloudBlockBlob blob = container.getBlockBlobReference(prefix);
            blob.downloadAttributes();
            HashMap<String, String> userDefinedMetadata = blob.getMetadata();
            BlobProperties properties = blob.getProperties();
            long contentLength = properties.getLength();
            String contentEncoding = properties.getContentEncoding();
            azureObjectMetadata = new AzureObjectMetadata(contentLength, contentEncoding, userDefinedMetadata);
        }
        catch (StorageException ex) {
            logger.debug("Failed to retrieve BLOB metadata: {} - {}", ex.getErrorCode(), ex.getExtendedErrorInformation());
            throw new StorageProviderException(ex);
        }
        catch (URISyntaxException ex) {
            logger.debug("Cannot retrieve BLOB properties, invalid URI: {}", ex);
            throw new StorageProviderException(ex);
        }
        return azureObjectMetadata;
    }

    @Override
    public void download(SFSession connection, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion) throws SnowflakeSQLException {
        int retryCount = 0;
        while (true) {
            try {
                String localFilePath = localLocation + localFileSep + destFileName;
                File localFile = new File(localFilePath);
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(stageFilePath);
                blob.downloadToFile(localFilePath);
                blob.downloadAttributes();
                HashMap<String, String> userDefinedMetadata = blob.getMetadata();
                AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData((String)userDefinedMetadata.get(AZ_ENCRYPTIONDATAPROP));
                String key = encryptionData.getKey();
                String iv = encryptionData.getValue();
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "File metadata incomplete");
                    }
                    try {
                        EncryptionProvider.decrypt(localFile, key, iv, this.encMat);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw ex;
                    }
                }
                return;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "download", connection, command, this);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void upload(SFSession connection, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion) throws SnowflakeSQLException {
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        Pair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose);
        if (!(meta instanceof AzureObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        int retryCount = 0;
        while (true) {
            try {
                logger.debug("Starting upload");
                InputStream fileInputStream = uploadStreamInfo.getLeft();
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(destFileName);
                blob.setMetadata((HashMap)meta.getUserMetadata());
                blob.upload(fileInputStream, -1L);
                logger.debug("Upload successful");
                blob.uploadMetadata();
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "upload", connection, command, this);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose);
                if (retryCount <= this.getMaxRetries()) continue;
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: upload unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession connection, String command) throws SnowflakeSQLException {
        SnowflakeAzureClient.handleAzureException(ex, retryCount, operation, connection, command, this);
    }

    private Pair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, StorageObjectMetadata meta, long originalContentLength, FileBackedOutputStream fileBackedOutputStream, List<FileInputStream> toClose) throws SnowflakeSQLException {
        InputStream stream;
        block10: {
            logger.debug("createUploadStream({}, {}, {}, {}, {}, {})", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
            FileInputStream srcFileStream = null;
            try {
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    try {
                        InputStream inputStream2;
                        if (uploadFromStream) {
                            inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                        } else {
                            srcFileStream = new FileInputStream(srcFile);
                            inputStream2 = srcFileStream;
                        }
                        InputStream uploadStream = inputStream2;
                        toClose.add(srcFileStream);
                        stream = EncryptionProvider.encrypt(meta, originalContentLength, uploadStream, this.encMat, this);
                        uploadFromStream = true;
                        break block10;
                    }
                    catch (Exception ex) {
                        logger.error("Failed to encrypt input", ex);
                        throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to encrypt input", ex.getMessage());
                    }
                }
                if (uploadFromStream) {
                    stream = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    toClose.add(srcFileStream);
                    stream = srcFileStream;
                }
            }
            catch (FileNotFoundException ex) {
                logger.error("Failed to open input file", ex);
                throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input file", ex.getMessage());
            }
            catch (IOException ex) {
                logger.error("Failed to open input stream", ex);
                throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input stream", ex.getMessage());
            }
        }
        return new ImmutablePair<InputStream, Boolean>(stream, uploadFromStream);
    }

    private static void handleAzureException(Exception ex, int retryCount, String operation, SFSession connection, String command, SnowflakeAzureClient azClient) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex);
        }
        if (((StorageException)ex).getHttpStatusCode() == 403) {
            SnowflakeFileTransferAgent.renewExpiredToken(connection, command, azClient);
        }
        if (ex instanceof StorageException) {
            StorageException se = (StorageException)ex;
            if (retryCount > azClient.getMaxRetries()) {
                throw new SnowflakeSQLException(se, "58000", (int)ErrorCode.AZURE_SERVICE_ERROR.getMessageCode(), operation, se.getErrorCode(), se.getExtendedErrorInformation(), se.getHttpStatusCode(), se.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = azClient.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, azClient.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (se.getHttpStatusCode() == 403) {
                SnowflakeFileTransferAgent.renewExpiredToken(connection, command, azClient);
            }
        } else if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > azClient.getMaxRetries()) {
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
        } else {
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
        }
    }

    private static URI buildAzureStorageEndpointURI(String storageEndPoint, String storageAccount) throws URISyntaxException {
        URI storageEndpoint = new URI("https", storageAccount + "." + storageEndPoint + "/", null, null);
        return storageEndpoint;
    }

    private String buildEncryptionMetadataJSON(String iv64, String key64) {
        return String.format("{\"EncryptionMode\":\"FullBlob\",\"WrappedContentKey\":{\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"%s\",\"Algorithm\":\"A192KW\"},\"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\"ContentEncryptionIV\":\"%s\",\"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}", key64, iv64);
    }

    private AbstractMap.SimpleEntry<String, String> parseEncryptionData(String jsonEncryptionData) throws SnowflakeSQLException {
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        try {
            JsonParser parser = factory.createJsonParser(jsonEncryptionData);
            JsonNode encryptionDataNode = (JsonNode)mapper.readTree(parser);
            String iv = encryptionDataNode.get("ContentEncryptionIV").asText();
            String key = encryptionDataNode.get("WrappedContentKey").get("EncryptedKey").asText();
            return new AbstractMap.SimpleEntry<String, String>(key, iv);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Error parsing encryption data as json: " + ex.getMessage());
        }
    }

    @Override
    public String getMatdescKey() {
        return "matdesc";
    }

    @Override
    public void addEncryptionMetadata(StorageObjectMetadata meta, MatDesc matDesc, byte[] ivData, byte[] encKeK, long contentLength) {
        meta.addUserMetadata(this.getMatdescKey(), matDesc.toString());
        meta.addUserMetadata(AZ_ENCRYPTIONDATAPROP, this.buildEncryptionMetadataJSON(Base64.encodeAsString(ivData), Base64.encodeAsString(encKeK)));
        meta.setContentLength(contentLength);
    }

    @Override
    public void addDigestMetadata(StorageObjectMetadata meta, String digest) {
        if (!StringUtils.isBlank(digest)) {
            meta.addUserMetadata("sfcdigest", digest);
        }
    }

    @Override
    public String getDigestMetadata(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get("sfcdigest");
    }
}

