/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.operator.bc;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidCipherTextException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.AsymmetricKeyWrapper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.GenericKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.bc.OperatorUtils;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.publicKey = asymmetricKeyParameter;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters cipherParameters = this.publicKey;
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        try {
            byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
            asymmetricBlockCipher.init(true, cipherParameters);
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to encrypt contents key", invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

