/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Blob;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.ParallelUploadConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.TransferManagerConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.TransferStatus;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.UploadResult;

final class UploadCallable
implements Callable<UploadResult> {
    private final TransferManagerConfig transferManagerConfig;
    private final Storage storage;
    private final BlobInfo originalBlob;
    private final Path sourceFile;
    private final ParallelUploadConfig parallelUploadConfig;
    private final Storage.BlobWriteOption[] opts;

    public UploadCallable(TransferManagerConfig transferManagerConfig, Storage storage, BlobInfo originalBlob, Path sourceFile, ParallelUploadConfig parallelUploadConfig, Storage.BlobWriteOption[] opts) {
        this.transferManagerConfig = transferManagerConfig;
        this.storage = storage;
        this.originalBlob = originalBlob;
        this.sourceFile = sourceFile;
        this.parallelUploadConfig = parallelUploadConfig;
        this.opts = opts;
    }

    @Override
    public UploadResult call() throws Exception {
        return this.uploadWithoutChunking();
    }

    private UploadResult uploadWithoutChunking() {
        try {
            Blob from = this.storage.createFrom(this.originalBlob, this.sourceFile, this.opts);
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setUploadedBlob(from.asBlobInfo()).build();
        }
        catch (StorageException e) {
            if (this.parallelUploadConfig.isSkipIfExists() && e.getCode() == 412) {
                return UploadResult.newBuilder(this.originalBlob, TransferStatus.SKIPPED).setException(e).build();
            }
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
        catch (Exception e) {
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
    }
}

