/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ContainerCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.InstanceProfileCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class EC2ContainerCredentialsProviderWrapper
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(EC2ContainerCredentialsProviderWrapper.class);
    private final AWSCredentialsProvider provider = this.initializeProvider();

    private AWSCredentialsProvider initializeProvider() {
        try {
            return System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI") != null ? new ContainerCredentialsProvider() : InstanceProfileCredentialsProvider.getInstance();
        }
        catch (SecurityException securityException) {
            LOG.debug("Security manager did not allow access to the ECS credentials environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI. Please provide access to this environment variable if you want to load credentials from ECS Container.");
            return InstanceProfileCredentialsProvider.getInstance();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.provider.getCredentials();
    }

    @Override
    public void refresh() {
        this.provider.refresh();
    }
}

