/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFBaseResultSet {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseResultSet.class);
    protected boolean wasNull = false;
    protected SFResultSetMetaData resultSetMetaData = null;
    protected int row = 0;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected TimeZone timeZone;
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    protected SnowflakeDateTimeFormat timestampNTZFormatter;
    protected SnowflakeDateTimeFormat timestampLTZFormatter;
    protected SnowflakeDateTimeFormat timestampTZFormatter;
    protected SnowflakeDateTimeFormat dateFormatter;
    protected SnowflakeDateTimeFormat timeFormatter;
    protected boolean honorClientTZForTimestampNTZ = true;
    protected SFBinaryFormat binaryFormatter;
    protected long resultVersion = 0L;
    protected int numberOfBinds = 0;
    protected SFSession session;
    protected boolean isClosed = true;

    public void setSession(SFSession session) {
        this.session = session;
    }

    public boolean next() throws SFException, SnowflakeSQLException {
        logger.debug("public boolean next()");
        return false;
    }

    public void close() {
        logger.debug("public void close()");
        this.resultSetMetaData = null;
        this.isClosed = true;
    }

    public boolean wasNull() {
        logger.debug("public boolean wasNull() returning {}", this.wasNull);
        return this.wasNull;
    }

    public String getString(int columnIndex) throws SFException {
        logger.debug("public String getString(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                return ResultUtil.getBooleanAsString(ResultUtil.getBoolean(obj.toString()));
            }
            case 93: 
            case 50000: 
            case 50001: {
                SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
                int columnScale = this.resultSetMetaData.getScale(columnIndex);
                String timestampStr = ResultUtil.getSFTimestampAsString(sfTS, columnType, columnScale, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting timestamp to string from: {} to: {}", obj.toString(), timestampStr);
                }
                return timestampStr;
            }
            case 91: {
                Date date = this.getDate(columnIndex, timeZoneUTC);
                if (this.dateFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing date formatter");
                }
                String dateStr = ResultUtil.getDateAsString(date, this.dateFormatter);
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting date to string from: {} to: {}", obj.toString(), dateStr);
                }
                return dateStr;
            }
            case 92: {
                SFTime sfTime = this.getSFTime(columnIndex);
                if (this.timeFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing time formatter");
                }
                int scale = this.resultSetMetaData.getScale(columnIndex);
                String timeStr = ResultUtil.getSFTimeAsString(sfTime, scale, this.timeFormatter);
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting time to string from: {} to: {}", obj.toString(), timeStr);
                }
                return timeStr;
            }
            case -2: {
                if (this.binaryFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing binary formatter");
                }
                if (this.binaryFormatter == SFBinaryFormat.HEX) {
                    return obj.toString();
                }
                SFBinary sfb = new SFBinary(this.getBytes(columnIndex));
                return this.binaryFormatter.format(sfb);
            }
        }
        return obj.toString();
    }

    public boolean getBoolean(int columnIndex) throws SFException {
        logger.debug("public boolean getBoolean(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return ResultUtil.getBoolean(obj.toString());
    }

    public short getShort(int columnIndex) throws SFException {
        logger.debug("public short getShort(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Short.parseShort((String)obj);
        }
        return ((Number)obj).shortValue();
    }

    public int getInt(int columnIndex) throws SFException {
        logger.debug("public int getInt(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return ((Number)obj).intValue();
    }

    public long getLong(int columnIndex) throws SFException {
        logger.debug("public long getLong(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            int columnType = this.resultSetMetaData.getColumnType(columnIndex);
            if (4 == columnType || 5 == columnType) {
                SFException sfe = new SFException(ErrorCode.INTERNAL_ERROR, "Invalid long: " + obj.toString());
                IncidentUtil.generateIncident(this.session, "Unable to Convert to Long", null, null, null, sfe);
                throw sfe;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "LONG", obj);
        }
    }

    public float getFloat(int columnIndex) throws SFException {
        logger.debug("public float getFloat(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof String) {
            if ("inf".equals(obj)) {
                return Float.POSITIVE_INFINITY;
            }
            if ("-inf".equals(obj)) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.parseFloat((String)obj);
        }
        return ((Number)obj).floatValue();
    }

    public double getDouble(int columnIndex) throws SFException {
        logger.debug("public double getDouble(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            if ("inf".equals(obj)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-inf".equals(obj)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble((String)obj);
        }
        return ((Number)obj).doubleValue();
    }

    public byte[] getBytes(int columnIndex) throws SFException {
        logger.debug("public byte[] getBytes(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        try {
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Invalid binary value: " + obj.toString());
        }
    }

    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        logger.debug("public Date getDate(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType) {
            return new Date(this.getTimestamp(columnIndex, tz).getTime());
        }
        if (91 == columnType) {
            return ResultUtil.getDate(obj.toString(), tz, this.session);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "DATE", obj);
    }

    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    public Time getTime(int columnIndex) throws SFException {
        logger.debug("public Time getTime(int columnIndex)");
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (92 == columnType) {
            SFTime sfTime = this.getSFTime(columnIndex);
            if (sfTime == null) {
                return null;
            }
            return new Time(sfTime.getFractionalSeconds(3));
        }
        if (93 == columnType) {
            return new Time(this.getTimestamp(columnIndex).getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "Time", this.getObjectInternal(columnIndex));
    }

    private SFTime getSFTime(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return ResultUtil.getSFTime(obj.toString(), scale, this.session);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }

    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType) {
            SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
            if (sfTS == null) {
                return null;
            }
            Timestamp res = sfTS.getTimestamp();
            if (res == null) {
                return null;
            }
            if (this.honorClientTZForTimestampNTZ && this.resultSetMetaData.getInternalColumnType(columnIndex) == 93) {
                return sfTS.moveToTimeZone(tz).getTimestamp();
            }
            return res;
        }
        if (91 == columnType) {
            return new Timestamp(this.getDate(columnIndex, tz).getTime());
        }
        if (92 == columnType) {
            return new Timestamp(this.getTime(columnIndex).getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "Timestamp", this.getObjectInternal(columnIndex));
    }

    private SFTimestamp getSFTimestamp(int columnIndex) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return ResultUtil.getSFTimestamp(obj.toString(), this.resultSetMetaData.getScale(columnIndex), this.resultSetMetaData.getInternalColumnType(columnIndex), this.resultVersion, this.timeZone, this.session);
    }

    public SFResultSetMetaData getMetaData() throws SFException {
        logger.debug("public ResultSetMetaData getMetaData()");
        return this.resultSetMetaData;
    }

    protected abstract Object getObjectInternal(int var1) throws SFException;

    public Object getObject(int columnIndex) throws SFException {
        logger.debug("public Object getObject(int columnIndex)");
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return new BigDecimal(obj.toString());
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    public int getRow() throws SQLException {
        logger.debug("public int getRow()");
        return this.row;
    }

    public boolean absolute(int row) throws SFException {
        logger.debug("public boolean absolute(int row)");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a specific row");
    }

    public boolean relative(int rows) throws SFException {
        logger.debug("public boolean relative(int rows)");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a row relative to current row");
    }

    public boolean previous() throws SFException {
        logger.debug("public boolean previous()");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a previous row");
    }

    protected int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public boolean isFirst() {
        logger.debug("public boolean isFirst()");
        return this.row == 1;
    }

    public abstract SFStatementType getStatementType();

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isArrayBindSupported() {
        return false;
    }
}

