/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.Objects;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageV2ProtoUtils;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WriteCtx;
import net.snowflake.client.jdbc.internal.google.storage.v2.StartResumableWriteRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.StartResumableWriteResponse;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectRequest;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class ResumableWrite
implements WriteCtx.WriteObjectRequestBuilderFactory {
    private final StartResumableWriteRequest req;
    private final StartResumableWriteResponse res;
    private final WriteObjectRequest writeRequest;

    public ResumableWrite(StartResumableWriteRequest req, StartResumableWriteResponse res, Function<String, WriteObjectRequest> f) {
        this.req = req;
        this.res = res;
        this.writeRequest = f.apply(res.getUploadId());
    }

    public StartResumableWriteRequest getReq() {
        return this.req;
    }

    public StartResumableWriteResponse getRes() {
        return this.res;
    }

    @Override
    public WriteObjectRequest.Builder newBuilder() {
        return this.writeRequest.toBuilder();
    }

    @Override
    public @Nullable String bucketName() {
        if (this.req.hasWriteObjectSpec() && this.req.getWriteObjectSpec().hasResource()) {
            return this.req.getWriteObjectSpec().getResource().getBucket();
        }
        return null;
    }

    public String toString() {
        return "ResumableWrite{req=" + StorageV2ProtoUtils.fmtProto(this.req) + ", res=" + StorageV2ProtoUtils.fmtProto(this.res) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResumableWrite)) {
            return false;
        }
        ResumableWrite resumableWrite = (ResumableWrite)o;
        return Objects.equals(this.req, resumableWrite.req) && Objects.equals(this.res, resumableWrite.res);
    }

    public int hashCode() {
        return Objects.hash(this.req, this.res);
    }

    static ResumableWrite identity(ResumableWrite w) {
        return w;
    }
}

