/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWECryptoParts;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEEncrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AAD;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, aad, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

