/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.CriticalHeaderParamsAware;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AAD;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AESCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AESGCMKW;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AESKW;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESDecrypter
extends AESCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public AESDecrypter(SecretKey kek) throws KeyLengthException {
        this(kek, (Set<String>)null);
    }

    public AESDecrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public AESDecrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    public AESDecrypter(SecretKey kek, Set<String> defCritHeaders) throws KeyLengthException {
        super(kek, null);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        return this.decrypt(header, encryptedKey, iv, cipherText, authTag, AAD.compute(header));
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag, byte[] aad) throws JOSEException {
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        this.critPolicy.ensureHeaderPasses(header);
        int keyLength = header.getEncryptionMethod().cekBitLength();
        if (alg.equals(JWEAlgorithm.A128KW) || alg.equals(JWEAlgorithm.A192KW) || alg.equals(JWEAlgorithm.A256KW)) {
            cek = AESKW.unwrapCEK(this.getKey(), encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (alg.equals(JWEAlgorithm.A128GCMKW) || alg.equals(JWEAlgorithm.A192GCMKW) || alg.equals(JWEAlgorithm.A256GCMKW)) {
            if (header.getIV() == null) {
                throw new JOSEException("Missing JWE \"iv\" header parameter");
            }
            byte[] keyIV = header.getIV().decode();
            if (header.getAuthTag() == null) {
                throw new JOSEException("Missing JWE \"tag\" header parameter");
            }
            byte[] keyTag = header.getAuthTag().decode();
            AuthenticatedCipherText authEncrCEK = new AuthenticatedCipherText(encryptedKey.decode(), keyTag);
            cek = AESGCMKW.decryptCEK(this.getKey(), keyIV, authEncrCEK, keyLength, this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(header, aad, encryptedKey, iv, cipherText, authTag, cek, this.getJCAContext());
    }
}

