/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.util.stream.Collectors;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;

public class MapConverter
extends AbstractArrowVectorConverter {
    private final MapVector vector;

    public MapConverter(MapVector valueVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.MAP.name(), valueVector, columnIndex, context);
        this.vector = valueVector;
    }

    @Override
    public Object toObject(int index) throws SFException {
        Object entriesList = this.vector.getObject(index);
        return entriesList.stream().collect(Collectors.toMap(entry -> entry.get("key").toString(), entry -> entry.get("value")));
    }

    @Override
    public String toString(int index) throws SFException {
        return this.vector.getObject(index).toString();
    }
}

