/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.digest;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CipherKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.digests.MD5Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.macs.HMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class MD5 {
    private MD5() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD5Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new MD5Digest((MD5Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD5Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD5", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD5.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.MD5", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
            this.addHMACAlgorithm(configurableProvider, "MD5", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "MD5", IANAObjectIdentifiers.hmacMD5);
        }
    }
}

