/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.RequestParamsExtractor;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.RequestUrlParamsEncoder;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

class GrpcUnaryRequestParamCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    GrpcUnaryRequestParamCallable(UnaryCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder<RequestT>(Preconditions.checkNotNull(paramsExtractor));
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        ApiCallContext newCallContext = inputContext;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = GrpcCallContext.createDefault().nullToSelf(inputContext).withRequestParamsDynamicHeaderOption(encodedHeader);
        }
        return this.callable.futureCall(request, newCallContext);
    }
}

