/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import java.io.IOException;
import java.rmi.UnexpectedException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Future;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryThreadPool;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class TelemetryClient
implements Telemetry {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseSession.class);
    private static final String SF_PATH_TELEMETRY = "/telemetry/send";
    private static final String SF_PATH_TELEMETRY_SESSIONLESS = "/telemetry/send/sessionless";
    private final int forceFlushSize;
    private static final int DEFAULT_FORCE_FLUSH_SIZE = 100;
    private final String serverUrl;
    private final String telemetryUrl;
    private final SFSession session;
    private LinkedList<TelemetryData> logBatch;
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private boolean isClosed;
    private final CloseableHttpClient httpClient;
    private String authType;
    private String token;
    private Object locker = new Object();
    private boolean isTelemetryServiceAvailable = true;
    private static final int TELEMETRY_HTTP_RETRY_TIMEOUT_IN_SEC = 1000;

    private TelemetryClient(SFSession session, int flushSize) {
        this.session = session;
        this.serverUrl = session.getUrl();
        this.httpClient = null;
        this.telemetryUrl = this.serverUrl.endsWith("/") ? this.serverUrl.substring(0, this.serverUrl.length() - 1) + SF_PATH_TELEMETRY : this.serverUrl + SF_PATH_TELEMETRY;
        this.logBatch = new LinkedList();
        this.isClosed = false;
        this.forceFlushSize = flushSize;
    }

    private TelemetryClient(CloseableHttpClient httpClient, String serverUrl, String authType, int flushSize) {
        this.session = null;
        this.serverUrl = serverUrl;
        this.httpClient = httpClient;
        if (!Objects.equals(authType, "KEYPAIR_JWT") && !Objects.equals(authType, "OAUTH")) {
            throw new IllegalArgumentException("Invalid authType, should be \"KEYPAIR_JWT\" or \"OAUTH\"");
        }
        this.authType = authType;
        this.telemetryUrl = this.serverUrl.endsWith("/") ? this.serverUrl.substring(0, this.serverUrl.length() - 1) + SF_PATH_TELEMETRY_SESSIONLESS : this.serverUrl + SF_PATH_TELEMETRY_SESSIONLESS;
        this.logBatch = new LinkedList();
        this.isClosed = false;
        this.forceFlushSize = flushSize;
    }

    public boolean isTelemetryEnabled() {
        return (this.session == null || this.session.isClientTelemetryEnabled()) && this.isTelemetryServiceAvailable;
    }

    public void disableTelemetry() {
        this.isTelemetryServiceAvailable = false;
    }

    public static Telemetry createTelemetry(Connection conn, int flushSize) {
        try {
            return TelemetryClient.createTelemetry((SFSession)conn.unwrap(SnowflakeConnectionV1.class).getSFBaseSession(), flushSize);
        }
        catch (SQLException ex) {
            logger.debug("input connection is not a SnowflakeConnection", false);
            return null;
        }
    }

    public static Telemetry createTelemetry(Connection conn) {
        return TelemetryClient.createTelemetry(conn, 100);
    }

    public static Telemetry createTelemetry(SFSession session) {
        return TelemetryClient.createTelemetry(session, 100);
    }

    public static Telemetry createTelemetry(SFSession session, int flushSize) {
        return new TelemetryClient(session, flushSize);
    }

    public static Telemetry createSessionlessTelemetry(CloseableHttpClient httpClient, String serverUrl) {
        return TelemetryClient.createSessionlessTelemetry(httpClient, serverUrl, "KEYPAIR_JWT", 100);
    }

    public static Telemetry createSessionlessTelemetry(CloseableHttpClient httpClient, String serverUrl, String authType) {
        return TelemetryClient.createSessionlessTelemetry(httpClient, serverUrl, authType, 100);
    }

    public static Telemetry createSessionlessTelemetry(CloseableHttpClient httpClient, String serverUrl, String authType, int flushSize) {
        return new TelemetryClient(httpClient, serverUrl, authType, flushSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogToBatch(TelemetryData log) {
        if (this.isClosed) {
            logger.debug("Telemetry already closed", false);
            return;
        }
        if (!this.isTelemetryEnabled()) {
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            this.logBatch.add(log);
        }
        if (this.logBatch.size() >= this.forceFlushSize) {
            this.sendBatchAsync();
        }
    }

    public void addLogToBatch(ObjectNode message, long timeStamp) {
        this.addLogToBatch(new TelemetryData(message, timeStamp));
    }

    @Override
    public void close() {
        if (this.isClosed) {
            logger.debug("Telemetry client already closed", false);
            return;
        }
        try {
            this.sendBatchAsync().get();
        }
        catch (Throwable e) {
            logger.debug("Error when sending batch data, {}", e);
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Future<Boolean> sendBatchAsync() {
        return TelemetryThreadPool.getInstance().submit(() -> {
            try {
                return this.sendBatch();
            }
            catch (Throwable e) {
                logger.debug("Failed to send telemetry data, {}", e);
                return false;
            }
        });
    }

    @Override
    public void postProcess(String queryId, String sqlState, int vendorCode, Throwable ex) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBatch() throws IOException {
        LinkedList<TelemetryData> tmpList;
        if (this.isClosed) {
            throw new IOException("Telemetry connector is closed");
        }
        if (!this.isTelemetryEnabled()) {
            return false;
        }
        Object object = this.locker;
        synchronized (object) {
            tmpList = this.logBatch;
            this.logBatch = new LinkedList();
        }
        if (this.session != null && this.session.isClosed()) {
            throw new UnexpectedException("Session is closed when sending log");
        }
        if (!tmpList.isEmpty()) {
            String payload = TelemetryClient.logsToString(tmpList);
            logger.debugNoMask("Payload of telemetry is : " + payload);
            HttpPost post = new HttpPost(this.telemetryUrl);
            post.setEntity(new StringEntity(payload));
            post.setHeader("Content-type", "application/json");
            if (this.session == null) {
                post.setHeader("Authorization", "Bearer " + this.token);
                post.setHeader("X-Snowflake-Authorization-Token-Type", this.authType);
                post.setHeader("Accept", "application/json");
            } else {
                post.setHeader("Authorization", "Snowflake Token=\"" + this.session.getSessionToken() + "\"");
            }
            String response = null;
            try {
                response = this.session == null ? HttpUtil.executeGeneralRequest((HttpRequestBase)post, 1000, 0, 300000, 0, this.httpClient) : HttpUtil.executeGeneralRequest((HttpRequestBase)post, 1000, this.session.getAuthTimeout(), this.session.getHttpClientSocketTimeout(), 0, this.session.getHttpClientKey());
            }
            catch (SnowflakeSQLException e) {
                this.disableTelemetry();
                logger.error("Telemetry request failed, response: {}, exception: {}", response, e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean sendLog(TelemetryData log) throws IOException {
        this.addLogToBatch(log);
        return this.sendBatch();
    }

    public boolean sendLog(ObjectNode message, long timeStamp) throws IOException {
        return this.sendLog(new TelemetryData(message, timeStamp));
    }

    static ObjectNode logsToJson(LinkedList<TelemetryData> telemetryData) {
        ObjectNode node = mapper.createObjectNode();
        ArrayNode logs = mapper.createArrayNode();
        for (TelemetryData data : telemetryData) {
            logs.add(data.toJson());
        }
        node.set("logs", logs);
        return node;
    }

    static String logsToString(LinkedList<TelemetryData> telemetryData) {
        return TelemetryClient.logsToJson(telemetryData).toString();
    }

    public int bufferSize() {
        return this.logBatch.size();
    }

    public LinkedList<TelemetryData> logBuffer() {
        return new LinkedList<TelemetryData>(this.logBatch);
    }

    public void refreshToken(String token) {
        this.token = token;
    }
}

