/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.internal.ServiceConfigUtil;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingLoadBalancerHelper;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public abstract class MultiChildLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    public static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    private static final Logger logger = Logger.getLogger(MultiChildLoadBalancer.class.getName());
    private final Map<Object, ChildLbState> childLbStates = new HashMap<Object, ChildLbState>();
    private final LoadBalancer.Helper helper;
    protected final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private boolean resolvingAddresses;

    protected MultiChildLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        logger.log(Level.FINE, "Created");
    }

    protected LoadBalancer.SubchannelPicker getInitialPicker() {
        return EMPTY_PICKER;
    }

    protected LoadBalancer.SubchannelPicker getErrorPicker(Status error) {
        return new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error));
    }

    protected abstract Map<Object, ServiceConfigUtil.PolicySelection> getPolicySelectionMap(LoadBalancer.ResolvedAddresses var1);

    protected abstract LoadBalancer.SubchannelPicker getSubchannelPicker(Map<Object, LoadBalancer.SubchannelPicker> var1);

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            boolean bl = this.acceptResolvedAddressesInternal(resolvedAddresses);
            return bl;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    private boolean acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        logger.log(Level.FINE, "Received resolution result: {0}", resolvedAddresses);
        Map<Object, ServiceConfigUtil.PolicySelection> newChildPolicies = this.getPolicySelectionMap(resolvedAddresses);
        for (Map.Entry<Object, ServiceConfigUtil.PolicySelection> entry : newChildPolicies.entrySet()) {
            Object key = entry.getKey();
            LoadBalancerProvider childPolicyProvider = entry.getValue().getProvider();
            Object childConfig = entry.getValue().getConfig();
            if (!this.childLbStates.containsKey(key)) {
                this.childLbStates.put(key, new ChildLbState(key, childPolicyProvider, this.getInitialPicker()));
            } else {
                this.childLbStates.get(key).reactivate(childPolicyProvider);
            }
            GracefulSwitchLoadBalancer childLb = this.childLbStates.get(key).lb;
            LoadBalancer.ResolvedAddresses childAddresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).build();
            ((LoadBalancer)childLb).handleResolvedAddresses(childAddresses);
        }
        for (Object key : this.childLbStates.keySet()) {
            if (newChildPolicies.containsKey(key)) continue;
            this.childLbStates.get(key).deactivate();
        }
        this.updateOverallBalancingState();
        return true;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        logger.log(Level.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (ChildLbState state : this.childLbStates.values()) {
            if (state.deactivated) continue;
            gotoTransientFailure = false;
            state.lb.handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.getErrorPicker(error));
        }
    }

    @Override
    public void shutdown() {
        logger.log(Level.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    private void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (ChildLbState childLbState : this.childLbStates.values()) {
            if (childLbState.deactivated) continue;
            childPickers.put(childLbState.key, childLbState.currentPicker);
            overallState = MultiChildLoadBalancer.aggregateState(overallState, childLbState.currentState);
        }
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildLbState {
        private final Object key;
        private final GracefulSwitchLoadBalancer lb;
        private LoadBalancerProvider policyProvider;
        private ConnectivityState currentState = ConnectivityState.CONNECTING;
        private LoadBalancer.SubchannelPicker currentPicker;
        private boolean deactivated;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        ChildLbState(Object key, LoadBalancerProvider policyProvider, LoadBalancer.SubchannelPicker initialPicker) {
            this.key = key;
            this.policyProvider = policyProvider;
            this.lb = new GracefulSwitchLoadBalancer(new ChildLbStateHelper());
            this.lb.switchTo(policyProvider);
            this.currentPicker = initialPicker;
        }

        void deactivate() {
            if (this.deactivated) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.shutdown();
                    MultiChildLoadBalancer.this.childLbStates.remove(ChildLbState.this.key);
                }
            }
            this.deletionTimer = MultiChildLoadBalancer.this.syncContext.schedule(new DeletionTask(), 15L, TimeUnit.MINUTES, MultiChildLoadBalancer.this.timeService);
            this.deactivated = true;
            logger.log(Level.FINE, "Child balancer {0} deactivated", this.key);
        }

        void reactivate(LoadBalancerProvider policyProvider) {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                this.deactivated = false;
                logger.log(Level.FINE, "Child balancer {0} reactivated", this.key);
            }
            if (!this.policyProvider.getPolicyName().equals(policyProvider.getPolicyName())) {
                Object[] objects = new Object[]{this.key, this.policyProvider.getPolicyName(), policyProvider.getPolicyName()};
                logger.log(Level.FINE, "Child balancer {0} switching policy from {1} to {2}", objects);
                this.lb.switchTo(policyProvider);
                this.policyProvider = policyProvider;
            }
        }

        void shutdown() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            logger.log(Level.FINE, "Child balancer {0} deleted", this.key);
        }

        private final class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            private ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (!MultiChildLoadBalancer.this.childLbStates.containsKey(ChildLbState.this.key)) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!ChildLbState.this.deactivated && !MultiChildLoadBalancer.this.resolvingAddresses) {
                    MultiChildLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return MultiChildLoadBalancer.this.helper;
            }
        }
    }
}

