/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMethodDescriptor;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonDirectCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonDirectServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonExceptionCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonExceptionServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonServerStreamingRequestParamCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonUnaryRequestParamCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.longrunning.OperationSnapshot;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BatchingCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.Callables;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ClientContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.LongRunningClient;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.OperationCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.OperationCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.PagedCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.SpanName;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.TracedUnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;

public class HttpJsonCallableFactory {
    private static final Pattern FULL_METHOD_NAME_REGEX = Pattern.compile("^(.+)\\.(.+)$");

    private HttpJsonCallableFactory() {
    }

    private static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createDirectUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings) {
        UnaryCallable callable = new HttpJsonDirectCallable<RequestT, ResponseT>(httpJsonCallSettings.getMethodDescriptor(), httpJsonCallSettings.getTypeRegistry());
        if (httpJsonCallSettings.getParamsExtractor() != null) {
            callable = new HttpJsonUnaryRequestParamCallable<RequestT, ResponseT>(callable, httpJsonCallSettings.getParamsExtractor());
        }
        return callable;
    }

    static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable callable = new HttpJsonExceptionCallable<RequestT, ResponseT>(innerCallable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = new HttpJsonExceptionCallable<RequestT, ResponseT>(callable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, clientContext);
        return callable;
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> innerCallable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        innerCallable = new TracedUnaryCallable<RequestT, ResponseT>(innerCallable, clientContext.getTracerFactory(), HttpJsonCallableFactory.getSpanName(httpJsonCallSettings.getMethodDescriptor()));
        return HttpJsonCallableFactory.createUnaryCallable(innerCallable, callSettings, clientContext);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, pagedCallSettings, clientContext);
        UnaryCallable<RequestT, PagedListResponseT> pagedCallable = Callables.paged(callable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, batchingCallSettings, clientContext);
        callable = Callables.batching(callable, batchingCallSettings, clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT, MetadataT> OperationCallable<RequestT, ResponseT, MetadataT> createOperationCallable(OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings, ClientContext clientContext, LongRunningClient longRunningClient, UnaryCallable<RequestT, OperationSnapshot> operationSnapshotCallable) {
        OperationCallable<RequestT, ResponseT, MetadataT> operationCallable = Callables.longRunningOperation(operationSnapshotCallable, operationCallSettings, clientContext, longRunningClient);
        return operationCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsoncallSettings, ServerStreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        ServerStreamingCallable callable = new HttpJsonDirectServerStreamingCallable<RequestT, ResponseT>(httpJsoncallSettings.getMethodDescriptor());
        if (httpJsoncallSettings.getParamsExtractor() != null) {
            callable = new HttpJsonServerStreamingRequestParamCallable<RequestT, ResponseT>(callable, httpJsoncallSettings.getParamsExtractor());
        }
        callable = new HttpJsonExceptionServerStreamingCallable<RequestT, ResponseT>(callable, streamingCallSettings.getRetryableCodes());
        if (clientContext.getStreamWatchdog() != null) {
            callable = Callables.watched(callable, streamingCallSettings, clientContext);
        }
        callable = Callables.retrying(callable, streamingCallSettings, clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @InternalApi(value="Visible for testing")
    static SpanName getSpanName(@Nonnull ApiMethodDescriptor<?, ?> methodDescriptor) {
        Matcher matcher = FULL_METHOD_NAME_REGEX.matcher(methodDescriptor.getFullMethodName());
        Preconditions.checkArgument(matcher.matches(), "Invalid fullMethodName");
        return SpanName.of(matcher.group(1), matcher.group(2));
    }
}

