/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.QueryResultFormat;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFArrowResultSet;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.DefaultResultStreamProvider;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.ResultStreamProvider;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.RootAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowStreamReader;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.telemetry.NoOpTelemetryClient;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeResultSetSerializableV1
implements SnowflakeResultSetSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeResultSetSerializableV1.class);
    static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static final long LOW_MAX_MEMORY = 0x40000000L;
    String firstChunkStringData;
    int firstChunkRowCount;
    int chunkFileCount;
    List<ChunkFileMetadata> chunkFileMetadatas = new ArrayList<ChunkFileMetadata>();
    byte[] firstChunkByteData;
    int resultPrefetchThreads;
    String qrmk;
    Map<String, String> chunkHeadersMap = new HashMap<String, String>();
    SnowflakeConnectString snowflakeConnectionString;
    OCSPMode ocspMode;
    HttpClientSettingsKey httpClientKey;
    int networkTimeoutInMilli;
    int authTimeout;
    int socketTimeout;
    int maxHttpRetries;
    boolean isResultColumnCaseInsensitive;
    int resultSetType;
    int resultSetConcurrency;
    int resultSetHoldability;
    String queryId;
    String finalDatabaseName;
    String finalSchemaName;
    String finalRoleName;
    String finalWarehouseName;
    SFStatementType statementType;
    boolean totalRowCountTruncated;
    Map<String, Object> parameters = new HashMap<String, Object>();
    int columnCount;
    private List<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
    long resultVersion;
    int numberOfBinds;
    boolean arrayBindSupported;
    long sendResultTime;
    List<MetaDataOfBinds> metaDataOfBinds = new ArrayList<MetaDataOfBinds>();
    QueryResultFormat queryResultFormat;
    boolean treatNTZAsUTC;
    boolean formatDateWithTimezone;
    boolean useSessionTimezone;
    int sessionClientMemoryLimit;
    transient TimeZone timeZone;
    transient Optional<SFBaseSession> possibleSession = Optional.empty();
    transient boolean honorClientTZForTimestampNTZ;
    transient SnowflakeDateTimeFormat timestampNTZFormatter;
    transient SnowflakeDateTimeFormat timestampLTZFormatter;
    transient SnowflakeDateTimeFormat timestampTZFormatter;
    transient SnowflakeDateTimeFormat dateFormatter;
    transient SnowflakeDateTimeFormat timeFormatter;
    transient SFBinaryFormat binaryFormatter;
    transient long memoryLimit;
    transient JsonNode firstChunkRowset = null;
    transient ChunkDownloader chunkDownloader = null;
    transient RootAllocator rootAllocator = null;
    transient SFResultSetMetaData resultSetMetaData = null;
    transient ResultStreamProvider resultStreamProvider = new DefaultResultStreamProvider();

    public SnowflakeResultSetSerializableV1() {
    }

    private SnowflakeResultSetSerializableV1(SnowflakeResultSetSerializableV1 toCopy) {
        this.firstChunkStringData = toCopy.firstChunkStringData;
        this.firstChunkRowCount = toCopy.firstChunkRowCount;
        this.chunkFileCount = toCopy.chunkFileCount;
        this.chunkFileMetadatas = toCopy.chunkFileMetadatas;
        this.firstChunkByteData = toCopy.firstChunkByteData;
        this.resultPrefetchThreads = toCopy.resultPrefetchThreads;
        this.qrmk = toCopy.qrmk;
        this.chunkHeadersMap = toCopy.chunkHeadersMap;
        this.snowflakeConnectionString = toCopy.snowflakeConnectionString;
        this.ocspMode = toCopy.ocspMode;
        this.httpClientKey = toCopy.httpClientKey;
        this.networkTimeoutInMilli = toCopy.networkTimeoutInMilli;
        this.authTimeout = toCopy.authTimeout;
        this.socketTimeout = toCopy.socketTimeout;
        this.maxHttpRetries = toCopy.maxHttpRetries;
        this.isResultColumnCaseInsensitive = toCopy.isResultColumnCaseInsensitive;
        this.resultSetType = toCopy.resultSetType;
        this.resultSetConcurrency = toCopy.resultSetConcurrency;
        this.resultSetHoldability = toCopy.resultSetHoldability;
        this.treatNTZAsUTC = toCopy.treatNTZAsUTC;
        this.formatDateWithTimezone = toCopy.formatDateWithTimezone;
        this.useSessionTimezone = toCopy.useSessionTimezone;
        this.queryId = toCopy.queryId;
        this.finalDatabaseName = toCopy.finalDatabaseName;
        this.finalSchemaName = toCopy.finalSchemaName;
        this.finalRoleName = toCopy.finalRoleName;
        this.finalWarehouseName = toCopy.finalWarehouseName;
        this.statementType = toCopy.statementType;
        this.totalRowCountTruncated = toCopy.totalRowCountTruncated;
        this.parameters = toCopy.parameters;
        this.columnCount = toCopy.columnCount;
        this.resultColumnMetadata = toCopy.resultColumnMetadata;
        this.resultVersion = toCopy.resultVersion;
        this.numberOfBinds = toCopy.numberOfBinds;
        this.arrayBindSupported = toCopy.arrayBindSupported;
        this.sendResultTime = toCopy.sendResultTime;
        this.metaDataOfBinds = toCopy.metaDataOfBinds;
        this.queryResultFormat = toCopy.queryResultFormat;
        this.possibleSession = toCopy.possibleSession;
        this.timeZone = toCopy.timeZone;
        this.honorClientTZForTimestampNTZ = toCopy.honorClientTZForTimestampNTZ;
        this.timestampNTZFormatter = toCopy.timestampNTZFormatter;
        this.timestampLTZFormatter = toCopy.timestampLTZFormatter;
        this.timestampTZFormatter = toCopy.timestampTZFormatter;
        this.dateFormatter = toCopy.dateFormatter;
        this.timeFormatter = toCopy.timeFormatter;
        this.binaryFormatter = toCopy.binaryFormatter;
        this.memoryLimit = toCopy.memoryLimit;
        this.firstChunkRowset = toCopy.firstChunkRowset;
        this.chunkDownloader = toCopy.chunkDownloader;
        this.rootAllocator = toCopy.rootAllocator;
        this.resultSetMetaData = toCopy.resultSetMetaData;
        this.resultStreamProvider = toCopy.resultStreamProvider;
    }

    public void setRootAllocator(RootAllocator rootAllocator) {
        this.rootAllocator = rootAllocator;
    }

    public void setQueryResultFormat(QueryResultFormat queryResultFormat) {
        this.queryResultFormat = queryResultFormat;
    }

    public void setChunkFileCount(int chunkFileCount) {
        this.chunkFileCount = chunkFileCount;
    }

    public void setFirstChunkStringData(String firstChunkStringData) {
        this.firstChunkStringData = firstChunkStringData;
    }

    public void setFirstChunkByteData(byte[] firstChunkByteData) {
        this.firstChunkByteData = firstChunkByteData;
    }

    public void setChunkDownloader(ChunkDownloader chunkDownloader) {
        this.chunkDownloader = chunkDownloader;
    }

    public void setResultStreamProvider(ResultStreamProvider resultStreamProvider) {
        this.resultStreamProvider = resultStreamProvider;
    }

    public ResultStreamProvider getResultStreamProvider() {
        return this.resultStreamProvider;
    }

    public SFResultSetMetaData getSFResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public SnowflakeConnectString getSnowflakeConnectString() {
        return this.snowflakeConnectionString;
    }

    public OCSPMode getOCSPMode() {
        return this.ocspMode;
    }

    public HttpClientSettingsKey getHttpClientKey() {
        return this.httpClientKey;
    }

    public String getQrmk() {
        return this.qrmk;
    }

    public int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getMaxHttpRetries() {
        return this.maxHttpRetries;
    }

    public int getResultPrefetchThreads() {
        return this.resultPrefetchThreads;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public Map<String, String> getChunkHeadersMap() {
        return this.chunkHeadersMap;
    }

    public List<ChunkFileMetadata> getChunkFileMetadatas() {
        return this.chunkFileMetadatas;
    }

    public RootAllocator getRootAllocator() {
        return this.rootAllocator;
    }

    public QueryResultFormat getQueryResultFormat() {
        return this.queryResultFormat;
    }

    public int getChunkFileCount() {
        return this.chunkFileCount;
    }

    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getFinalDatabaseName() {
        return this.finalDatabaseName;
    }

    public String getFinalSchemaName() {
        return this.finalSchemaName;
    }

    public String getFinalRoleName() {
        return this.finalRoleName;
    }

    public String getFinalWarehouseName() {
        return this.finalWarehouseName;
    }

    public SFStatementType getStatementType() {
        return this.statementType;
    }

    public boolean isTotalRowCountTruncated() {
        return this.totalRowCountTruncated;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<SnowflakeColumnMetadata> getResultColumnMetadata() {
        return this.resultColumnMetadata;
    }

    public JsonNode getAndClearFirstChunkRowset() {
        JsonNode firstChunkRowset = this.firstChunkRowset;
        this.firstChunkRowset = null;
        return firstChunkRowset;
    }

    public int getFirstChunkRowCount() {
        return this.firstChunkRowCount;
    }

    public long getResultVersion() {
        return this.resultVersion;
    }

    public int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public ChunkDownloader getChunkDownloader() {
        return this.chunkDownloader;
    }

    public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
        return this.timestampLTZFormatter;
    }

    public SnowflakeDateTimeFormat getTimestampTZFormatter() {
        return this.timestampTZFormatter;
    }

    public SnowflakeDateTimeFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public SnowflakeDateTimeFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isHonorClientTZForTimestampNTZ() {
        return this.honorClientTZForTimestampNTZ;
    }

    public SFBinaryFormat getBinaryFormatter() {
        return this.binaryFormatter;
    }

    public long getSendResultTime() {
        return this.sendResultTime;
    }

    public List<MetaDataOfBinds> getMetaDataOfBinds() {
        return this.metaDataOfBinds;
    }

    public String getFirstChunkStringData() {
        return this.firstChunkStringData;
    }

    public byte[] getFirstChunkByteData() {
        return this.firstChunkByteData;
    }

    public boolean getTreatNTZAsUTC() {
        return this.treatNTZAsUTC;
    }

    public boolean getFormatDateWithTimeZone() {
        return this.formatDateWithTimezone;
    }

    public boolean getUseSessionTimezone() {
        return this.useSessionTimezone;
    }

    public Optional<SFBaseSession> getSession() {
        return this.possibleSession;
    }

    public static SnowflakeResultSetSerializableV1 create(JsonNode rootNode, SFBaseSession sfSession, SFBaseStatement sfStatement) throws SnowflakeSQLException {
        return SnowflakeResultSetSerializableV1.create(rootNode, sfSession, sfStatement, new DefaultResultStreamProvider());
    }

    public static SnowflakeResultSetSerializableV1 create(JsonNode rootNode, SFBaseSession sfSession, SFBaseStatement sfStatement, ResultStreamProvider resultStreamProvider) throws SnowflakeSQLException {
        JsonNode arrayBindSupported;
        JsonNode numberOfBindsNode;
        String queryContext;
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        logger.debug("Entering create()", false);
        SnowflakeUtil.checkErrorAndThrowException(rootNode);
        resultSetSerializable.queryId = rootNode.path("data").path("queryId").asText();
        JsonNode databaseNode = rootNode.path("data").path("finalDatabaseName");
        resultSetSerializable.finalDatabaseName = databaseNode.isNull() ? (sfSession != null ? sfSession.getDatabase() : null) : databaseNode.asText();
        JsonNode schemaNode = rootNode.path("data").path("finalSchemaName");
        resultSetSerializable.finalSchemaName = schemaNode.isNull() ? (sfSession != null ? sfSession.getSchema() : null) : schemaNode.asText();
        JsonNode roleNode = rootNode.path("data").path("finalRoleName");
        resultSetSerializable.finalRoleName = roleNode.isNull() ? (sfSession != null ? sfSession.getRole() : null) : roleNode.asText();
        JsonNode warehouseNode = rootNode.path("data").path("finalWarehouseName");
        resultSetSerializable.finalWarehouseName = warehouseNode.isNull() ? (sfSession != null ? sfSession.getWarehouse() : null) : warehouseNode.asText();
        resultSetSerializable.statementType = SFStatementType.lookUpTypeById(rootNode.path("data").path("statementTypeId").asLong());
        resultSetSerializable.totalRowCountTruncated = rootNode.path("data").path("totalTruncated").asBoolean();
        resultSetSerializable.possibleSession = Optional.ofNullable(sfSession);
        logger.debug("query id: {}", resultSetSerializable.queryId);
        Optional<QueryResultFormat> queryResultFormat = QueryResultFormat.lookupByName(rootNode.path("data").path("queryResultFormat").asText());
        resultSetSerializable.queryResultFormat = queryResultFormat.orElse(QueryResultFormat.JSON);
        JsonNode queryContextNode = rootNode.path("data").path("queryContext");
        String string = queryContext = queryContextNode.isNull() ? null : queryContextNode.toString();
        if (!sfSession.isAsyncSession()) {
            sfSession.setQueryContext(queryContext);
        }
        resultSetSerializable.parameters = SessionUtil.getCommonParams(rootNode.path("data").path("parameters"));
        if (resultSetSerializable.parameters.isEmpty()) {
            resultSetSerializable.parameters = sfSession.getCommonParameters();
            resultSetSerializable.setStatemementLevelParameters(sfStatement.getStatementParameters());
        }
        resultSetSerializable.columnCount = rootNode.path("data").path("rowtype").size();
        for (int i = 0; i < resultSetSerializable.columnCount; ++i) {
            JsonNode colNode = rootNode.path("data").path("rowtype").path(i);
            SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata(colNode, sfSession.isJdbcTreatDecimalAsInt(), sfSession);
            resultSetSerializable.resultColumnMetadata.add(columnMetadata);
            logger.debug("Get column metadata: {}", () -> columnMetadata.toString());
        }
        resultSetSerializable.resultStreamProvider = resultStreamProvider;
        if (resultSetSerializable.queryResultFormat == QueryResultFormat.ARROW) {
            resultSetSerializable.firstChunkStringData = rootNode.path("data").path("rowsetBase64").asText();
            resultSetSerializable.rootAllocator = new RootAllocator(Long.MAX_VALUE);
            resultSetSerializable.setFirstChunkRowCountForArrow();
        } else {
            resultSetSerializable.firstChunkRowset = rootNode.path("data").path("rowset");
            if (resultSetSerializable.firstChunkRowset == null || resultSetSerializable.firstChunkRowset.isMissingNode()) {
                resultSetSerializable.firstChunkRowCount = 0;
                resultSetSerializable.firstChunkStringData = null;
                resultSetSerializable.firstChunkByteData = new byte[0];
            } else {
                resultSetSerializable.firstChunkRowCount = resultSetSerializable.firstChunkRowset.size();
                resultSetSerializable.firstChunkStringData = resultSetSerializable.firstChunkRowset.toString();
            }
        }
        logger.debug("First chunk row count: {}", resultSetSerializable.firstChunkRowCount);
        resultSetSerializable.parseChunkFiles(rootNode, sfStatement);
        JsonNode versionNode = rootNode.path("data").path("version");
        if (!versionNode.isMissingNode()) {
            resultSetSerializable.resultVersion = versionNode.longValue();
        }
        if (!(numberOfBindsNode = rootNode.path("data").path("numberOfBinds")).isMissingNode()) {
            resultSetSerializable.numberOfBinds = numberOfBindsNode.intValue();
        }
        resultSetSerializable.arrayBindSupported = !(arrayBindSupported = rootNode.path("data").path("arrayBindSupported")).isMissingNode() && arrayBindSupported.asBoolean();
        JsonNode sendResultTimeNode = rootNode.path("data").path("sendResultTime");
        if (!sendResultTimeNode.isMissingNode()) {
            resultSetSerializable.sendResultTime = sendResultTimeNode.longValue();
        }
        logger.debug("result version={}", resultSetSerializable.resultVersion);
        JsonNode bindData = rootNode.path("data").path("metaDataOfBinds");
        if (!bindData.isMissingNode()) {
            ArrayList<MetaDataOfBinds> returnVal = new ArrayList<MetaDataOfBinds>();
            for (JsonNode child : bindData) {
                int precision = child.path("precision").asInt();
                boolean nullable = child.path("nullable").asBoolean();
                int scale = child.path("scale").asInt();
                int byteLength = child.path("byteLength").asInt();
                int length = child.path("length").asInt();
                String name = child.path("name").asText();
                String type = child.path("type").asText();
                MetaDataOfBinds param = new MetaDataOfBinds(precision, nullable, scale, byteLength, length, name, type);
                returnVal.add(param);
            }
            resultSetSerializable.metaDataOfBinds = returnVal;
        }
        resultSetSerializable.ocspMode = sfSession.getOCSPMode();
        resultSetSerializable.httpClientKey = sfSession.getHttpClientKey();
        resultSetSerializable.snowflakeConnectionString = sfSession.getSnowflakeConnectionString();
        resultSetSerializable.networkTimeoutInMilli = sfSession.getNetworkTimeoutInMilli();
        resultSetSerializable.authTimeout = 0;
        resultSetSerializable.maxHttpRetries = sfSession.getMaxHttpRetries();
        resultSetSerializable.isResultColumnCaseInsensitive = sfSession.isResultColumnCaseInsensitive();
        resultSetSerializable.treatNTZAsUTC = sfSession.getTreatNTZAsUTC();
        resultSetSerializable.formatDateWithTimezone = sfSession.getFormatDateWithTimezone();
        resultSetSerializable.useSessionTimezone = sfSession.getUseSessionTimezone();
        resultSetSerializable.setupFieldsFromParameters();
        resultSetSerializable.chunkDownloader = resultSetSerializable.chunkFileCount > 0 ? new SnowflakeChunkDownloader(resultSetSerializable) : new SnowflakeChunkDownloader.NoOpChunkDownloader();
        resultSetSerializable.resultSetMetaData = new SFResultSetMetaData(resultSetSerializable.getResultColumnMetadata(), resultSetSerializable.queryId, sfSession, resultSetSerializable.isResultColumnCaseInsensitive, resultSetSerializable.timestampNTZFormatter, resultSetSerializable.timestampLTZFormatter, resultSetSerializable.timestampTZFormatter, resultSetSerializable.dateFormatter, resultSetSerializable.timeFormatter);
        return resultSetSerializable;
    }

    private void setupFieldsFromParameters() {
        String sqlTimestampFormat = (String)ResultUtil.effectiveParamValue(this.parameters, "TIMESTAMP_OUTPUT_FORMAT");
        this.timestampNTZFormatter = ResultUtil.specializedFormatter(this.parameters, "timestamp_ntz", "TIMESTAMP_NTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        this.timestampLTZFormatter = ResultUtil.specializedFormatter(this.parameters, "timestamp_ltz", "TIMESTAMP_LTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        this.timestampTZFormatter = ResultUtil.specializedFormatter(this.parameters, "timestamp_tz", "TIMESTAMP_TZ_OUTPUT_FORMAT", sqlTimestampFormat);
        String sqlDateFormat = (String)ResultUtil.effectiveParamValue(this.parameters, "DATE_OUTPUT_FORMAT");
        this.dateFormatter = SnowflakeDateTimeFormat.fromSqlFormat(sqlDateFormat);
        logger.debug("sql date format: {}, java date format: {}", sqlDateFormat, () -> this.dateFormatter.toSimpleDateTimePattern());
        String sqlTimeFormat = (String)ResultUtil.effectiveParamValue(this.parameters, "TIME_OUTPUT_FORMAT");
        this.timeFormatter = SnowflakeDateTimeFormat.fromSqlFormat(sqlTimeFormat);
        logger.debug("sql time format: {}, java time format: {}", sqlTimeFormat, () -> this.timeFormatter.toSimpleDateTimePattern());
        String timeZoneName = (String)ResultUtil.effectiveParamValue(this.parameters, "TIMEZONE");
        this.timeZone = TimeZone.getTimeZone(timeZoneName);
        this.honorClientTZForTimestampNTZ = (Boolean)ResultUtil.effectiveParamValue(this.parameters, "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
        logger.debug("Honoring client TZ for timestamp_ntz? {}", this.honorClientTZForTimestampNTZ);
        String binaryFmt = (String)ResultUtil.effectiveParamValue(this.parameters, "BINARY_OUTPUT_FORMAT");
        this.binaryFormatter = SFBinaryFormat.getSafeOutputFormat(binaryFmt);
    }

    private void parseChunkFiles(JsonNode rootNode, SFBaseStatement sfStatement) {
        JsonNode chunksNode = rootNode.path("data").path("chunks");
        if (!chunksNode.isMissingNode()) {
            this.chunkFileCount = chunksNode.size();
            JsonNode qrmkNode = rootNode.path("data").path("qrmk");
            String string = this.qrmk = qrmkNode.isMissingNode() ? null : qrmkNode.textValue();
            if (this.chunkFileCount > 0) {
                logger.debug("#chunks={}, initialize chunk downloader", this.chunkFileCount);
                this.adjustMemorySettings(sfStatement);
                JsonNode chunkHeaders = rootNode.path("data").path("chunkHeaders");
                if (chunkHeaders != null && !chunkHeaders.isMissingNode()) {
                    Iterator<Map.Entry<String, JsonNode>> chunkHeadersIter = chunkHeaders.fields();
                    while (chunkHeadersIter.hasNext()) {
                        Map.Entry<String, JsonNode> chunkHeader = chunkHeadersIter.next();
                        logger.debug("add header key={}, value={}", chunkHeader.getKey(), chunkHeader.getValue().asText());
                        this.chunkHeadersMap.put(chunkHeader.getKey(), chunkHeader.getValue().asText());
                    }
                }
                for (int idx = 0; idx < this.chunkFileCount; ++idx) {
                    JsonNode chunkNode = chunksNode.get(idx);
                    String url = chunkNode.path("url").asText();
                    int rowCount = chunkNode.path("rowCount").asInt();
                    int compressedSize = chunkNode.path("compressedSize").asInt();
                    int uncompressedSize = chunkNode.path("uncompressedSize").asInt();
                    this.chunkFileMetadatas.add(new ChunkFileMetadata(url, rowCount, compressedSize, uncompressedSize));
                    logger.debug("add chunk, url={} rowCount={} compressedSize={} uncompressedSize={}", url, rowCount, compressedSize, uncompressedSize);
                }
            }
        }
    }

    private void adjustMemorySettings(SFBaseStatement sfStatement) {
        this.resultPrefetchThreads = SessionUtil.DEFAULT_CLIENT_PREFETCH_THREADS;
        if (this.statementType.isSelect() && this.parameters.containsKey("CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE") && ((Boolean)this.parameters.get("CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE")).booleanValue()) {
            this.resultPrefetchThreads = sfStatement.getConservativePrefetchThreads();
            this.memoryLimit = sfStatement.getConservativeMemoryLimit();
            int chunkSize = (Integer)this.parameters.get("CLIENT_RESULT_CHUNK_SIZE");
            logger.debug("enable conservative memory usage with prefetchThreads = {} and memoryLimit = {} and resultChunkSize = {}", this.resultPrefetchThreads, this.memoryLimit, chunkSize);
        } else {
            if (this.parameters.get("CLIENT_PREFETCH_THREADS") != null) {
                this.resultPrefetchThreads = (Integer)this.parameters.get("CLIENT_PREFETCH_THREADS");
            }
            this.memoryLimit = SnowflakeResultSetSerializableV1.initMemoryLimit(this.parameters);
        }
        long maxChunkSize = (Integer)this.parameters.get("CLIENT_RESULT_CHUNK_SIZE") * 0x100000;
        if (this.queryResultFormat == QueryResultFormat.ARROW && Runtime.getRuntime().maxMemory() < 0x40000000L && this.memoryLimit * 2L + maxChunkSize > Runtime.getRuntime().maxMemory()) {
            this.memoryLimit = Runtime.getRuntime().maxMemory() / 2L - maxChunkSize;
            logger.debug("To avoid OOM for arrow buffer allocation, memoryLimit {} should be less than half of the maxMemory {} + maxChunkSize {}", this.memoryLimit, Runtime.getRuntime().maxMemory(), maxChunkSize);
        }
        if (sfStatement.getSFBaseSession().getMemoryLimitForTesting() != SFBaseSession.MEMORY_LIMIT_UNSET) {
            this.memoryLimit = sfStatement.getSFBaseSession().getMemoryLimitForTesting();
            logger.debug("memoryLimit changed for testing purposes to {}", this.memoryLimit);
        }
    }

    private static long initMemoryLimit(Map<String, Object> parameters) {
        long memoryLimit = SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT * 1024L * 1024L;
        long maxMemoryToUse = Runtime.getRuntime().maxMemory() * 8L / 10L;
        if (parameters.get("CLIENT_MEMORY_LIMIT") != null) {
            memoryLimit = (long)((Integer)parameters.get("CLIENT_MEMORY_LIMIT")).intValue() * 1024L * 1024L;
            if (SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT == (long)((Integer)parameters.get("CLIENT_MEMORY_LIMIT")).intValue()) {
                memoryLimit = Math.max(memoryLimit, maxMemoryToUse);
            }
        }
        memoryLimit = Math.min(memoryLimit, maxMemoryToUse);
        logger.debug("Set allowed memory usage to {} bytes", memoryLimit);
        return memoryLimit;
    }

    private void setStatemementLevelParameters(Map<String, Object> stmtParamsMap) {
        for (Map.Entry<String, Object> entry : stmtParamsMap.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    private void setupTransientFields() throws SQLException {
        this.setupFieldsFromParameters();
        this.memoryLimit = SnowflakeResultSetSerializableV1.initMemoryLimit(this.parameters);
        this.resultStreamProvider = new DefaultResultStreamProvider();
        if (QueryResultFormat.ARROW.equals((Object)this.queryResultFormat)) {
            this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
            this.firstChunkRowset = null;
        } else {
            this.rootAllocator = null;
            try {
                this.firstChunkRowset = this.firstChunkStringData != null ? mapper.readTree(this.firstChunkStringData) : null;
            }
            catch (IOException ex) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.possibleSession.orElse(null), "The JSON data is invalid. The error is: " + ex.getMessage());
            }
        }
        this.resultSetMetaData = new SFResultSetMetaData(this.getResultColumnMetadata(), this.queryId, null, this.isResultColumnCaseInsensitive, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
        this.chunkDownloader = this.chunkFileCount > 0 ? new SnowflakeChunkDownloader(this) : new SnowflakeChunkDownloader.NoOpChunkDownloader();
    }

    public List<SnowflakeResultSetSerializable> splitBySize(long maxSizeInBytes) throws SQLException {
        ArrayList<SnowflakeResultSetSerializable> resultSetSerializables = new ArrayList<SnowflakeResultSetSerializable>();
        if (this.chunkFileMetadatas.isEmpty() && this.firstChunkStringData == null) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.possibleSession.orElse(null), "The Result Set serializable is invalid.");
        }
        SnowflakeResultSetSerializableV1 curResultSetSerializable = new SnowflakeResultSetSerializableV1(this);
        curResultSetSerializable.chunkFileMetadatas = new ArrayList<ChunkFileMetadata>();
        curResultSetSerializable.chunkFileCount = 0;
        for (int idx = 0; idx < this.chunkFileCount; ++idx) {
            ChunkFileMetadata curChunkFileMetadata = this.getChunkFileMetadatas().get(idx);
            if (curResultSetSerializable.getUncompressedDataSizeInBytes() > 0L && maxSizeInBytes < curResultSetSerializable.getUncompressedDataSizeInBytes() + (long)curChunkFileMetadata.getUncompressedByteSize()) {
                resultSetSerializables.add(curResultSetSerializable);
                curResultSetSerializable = new SnowflakeResultSetSerializableV1(this);
                curResultSetSerializable.chunkFileMetadatas = new ArrayList<ChunkFileMetadata>();
                curResultSetSerializable.chunkFileCount = 0;
                curResultSetSerializable.firstChunkStringData = null;
                curResultSetSerializable.firstChunkRowCount = 0;
                curResultSetSerializable.firstChunkRowset = null;
                curResultSetSerializable.firstChunkByteData = new byte[0];
            }
            curResultSetSerializable.getChunkFileMetadatas().add(curChunkFileMetadata);
            ++curResultSetSerializable.chunkFileCount;
        }
        resultSetSerializables.add(curResultSetSerializable);
        return resultSetSerializables;
    }

    @Override
    public ResultSet getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig resultSetRetrieveConfig) throws SQLException {
        try {
            SessionUtil.resetOCSPUrlIfNecessary(resultSetRetrieveConfig.getSfFullURL());
        }
        catch (IOException e) {
            throw new SnowflakeSQLLoggedException(null, ErrorCode.INTERNAL_ERROR, new Object[]{"Hit exception when adjusting OCSP cache server. The original message is: " + e.getMessage()});
        }
        return this.getResultSetInternal(resultSetRetrieveConfig.getProxyProperties());
    }

    @Override
    @Deprecated
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetInternal(null);
    }

    @Override
    @Deprecated
    public ResultSet getResultSet(Properties info) throws SQLException {
        return this.getResultSetInternal(info);
    }

    private ResultSet getResultSetInternal(Properties info) throws SQLException {
        this.httpClientKey = SnowflakeUtil.convertProxyPropertiesToHttpClientKey(this.ocspMode, info);
        this.setupTransientFields();
        NoOpTelemetryClient telemetryClient = new NoOpTelemetryClient();
        boolean sortResult = false;
        SFBaseResultSet sfBaseResultSet = null;
        switch (this.getQueryResultFormat()) {
            case ARROW: {
                sfBaseResultSet = new SFArrowResultSet(this, telemetryClient, sortResult);
                break;
            }
            case JSON: {
                sfBaseResultSet = new SFResultSet(this, telemetryClient, sortResult);
                break;
            }
            default: {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.possibleSession.orElse(null), ErrorCode.INTERNAL_ERROR, "Unsupported query result format: " + this.getQueryResultFormat().name());
            }
        }
        SnowflakeResultSetV1 resultSetV1 = new SnowflakeResultSetV1(sfBaseResultSet, this);
        return resultSetV1;
    }

    private void setFirstChunkRowCountForArrow() throws SnowflakeSQLException {
        this.firstChunkRowCount = 0;
        this.firstChunkByteData = new byte[0];
        if (this.firstChunkStringData == null || this.firstChunkStringData.isEmpty()) {
            this.firstChunkRowCount = 0;
            this.firstChunkByteData = new byte[0];
        } else if (this.getQueryResultFormat().equals((Object)QueryResultFormat.ARROW)) {
            byte[] bytes = Base64.getDecoder().decode(this.firstChunkStringData);
            this.firstChunkByteData = bytes;
            VectorSchemaRoot root = null;
            RootAllocator localRootAllocator = this.rootAllocator != null ? this.rootAllocator : new RootAllocator(Long.MAX_VALUE);
            try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                 ArrowStreamReader reader = new ArrowStreamReader(is, (BufferAllocator)localRootAllocator);){
                root = reader.getVectorSchemaRoot();
                while (reader.loadNextBatch()) {
                    this.firstChunkRowCount += root.getRowCount();
                    root.clear();
                }
            }
            catch (ClosedByInterruptException cbie) {
                logger.debug("Interrupted when loading Arrow first chunk row count.", cbie);
            }
            catch (Exception ex) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.possibleSession.orElse(null), ErrorCode.INTERNAL_ERROR, "Fail to retrieve row count for first arrow chunk: " + ex.getMessage());
            }
            finally {
                if (root != null) {
                    root.clear();
                }
            }
        } else {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.possibleSession.orElse(null), ErrorCode.INTERNAL_ERROR, "setFirstChunkRowCountForArrow() should only be called for Arrow.");
        }
    }

    @Override
    public long getRowCount() throws SQLException {
        long totalRowCount = this.firstChunkRowCount;
        for (ChunkFileMetadata chunkFileMetadata : this.chunkFileMetadatas) {
            totalRowCount += (long)chunkFileMetadata.rowCount;
        }
        return totalRowCount;
    }

    @Override
    public long getCompressedDataSizeInBytes() throws SQLException {
        long totalCompressedDataSize = 0L;
        if (this.firstChunkStringData != null) {
            totalCompressedDataSize += (long)this.firstChunkStringData.length();
        }
        for (ChunkFileMetadata chunkFileMetadata : this.chunkFileMetadatas) {
            totalCompressedDataSize += (long)chunkFileMetadata.compressedByteSize;
        }
        return totalCompressedDataSize;
    }

    @Override
    public long getUncompressedDataSizeInBytes() throws SQLException {
        long totalUncompressedDataSize = 0L;
        if (this.firstChunkStringData != null) {
            totalUncompressedDataSize += (long)this.firstChunkStringData.length();
        }
        for (ChunkFileMetadata chunkFileMetadata : this.chunkFileMetadatas) {
            totalUncompressedDataSize += (long)chunkFileMetadata.uncompressedByteSize;
        }
        return totalUncompressedDataSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(16384);
        builder.append("hasFirstChunk: ").append(this.firstChunkStringData != null).append("\n");
        builder.append("RowCountInFirstChunk: ").append(this.firstChunkRowCount).append("\n");
        builder.append("queryResultFormat: ").append((Object)this.queryResultFormat).append("\n");
        builder.append("chunkFileCount: ").append(this.chunkFileCount).append("\n");
        for (ChunkFileMetadata chunkFileMetadata : this.chunkFileMetadatas) {
            builder.append("\t").append(chunkFileMetadata.toString()).append("\n");
        }
        return builder.toString();
    }

    public static class ChunkFileMetadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String fileURL;
        int rowCount;
        int compressedByteSize;
        int uncompressedByteSize;

        public ChunkFileMetadata(String fileURL, int rowCount, int compressedByteSize, int uncompressedByteSize) {
            this.fileURL = fileURL;
            this.rowCount = rowCount;
            this.compressedByteSize = compressedByteSize;
            this.uncompressedByteSize = uncompressedByteSize;
        }

        public void setFileURL(String fileURL) {
            this.fileURL = fileURL;
        }

        public String getFileURL() {
            return this.fileURL;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getCompressedByteSize() {
            return this.compressedByteSize;
        }

        public int getUncompressedByteSize() {
            return this.uncompressedByteSize;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("RowCount: ").append(this.rowCount).append(", ");
            builder.append("CompressedSize: ").append(this.compressedByteSize).append(", ");
            builder.append("UnCompressedSize: ").append(this.uncompressedByteSize);
            return builder.toString();
        }
    }
}

