/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.orca;

import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.grpc.Context;
import net.snowflake.client.jdbc.internal.grpc.Contexts;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.ForwardingServerCall;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.ServerCall;
import net.snowflake.client.jdbc.internal.grpc.ServerCallHandler;
import net.snowflake.client.jdbc.internal.grpc.ServerInterceptor;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.protobuf.ProtoUtils;
import net.snowflake.client.jdbc.internal.grpc.services.CallMetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.InternalCallMetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.InternalMetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.MetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.MetricReport;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9127")
public final class OrcaMetricReportingServerInterceptor
implements ServerInterceptor {
    private static final OrcaMetricReportingServerInterceptor INSTANCE = new OrcaMetricReportingServerInterceptor(null);
    @VisibleForTesting
    static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of("endpoint-load-metrics-bin", ProtoUtils.metadataMarshaller(OrcaLoadReport.getDefaultInstance()));
    @Nullable
    private final MetricRecorder metricRecorder;

    @VisibleForTesting
    OrcaMetricReportingServerInterceptor(@Nullable MetricRecorder metricRecorder) {
        this.metricRecorder = metricRecorder;
    }

    public static OrcaMetricReportingServerInterceptor getInstance() {
        return INSTANCE;
    }

    public static OrcaMetricReportingServerInterceptor create(@Nullable MetricRecorder metricRecorder) {
        return new OrcaMetricReportingServerInterceptor(metricRecorder);
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context ctx = Context.current();
        CallMetricRecorder callMetricRecorder = InternalCallMetricRecorder.CONTEXT_KEY.get(ctx);
        if (callMetricRecorder == null) {
            callMetricRecorder = InternalCallMetricRecorder.newCallMetricRecorder();
            ctx = ctx.withValue(InternalCallMetricRecorder.CONTEXT_KEY, callMetricRecorder);
        }
        final CallMetricRecorder finalCallMetricRecorder = callMetricRecorder;
        ForwardingServerCall.SimpleForwardingServerCall trailerAttachingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            @Override
            public void close(Status status, Metadata trailers) {
                OrcaLoadReport.Builder reportBuilder = OrcaMetricReportingServerInterceptor.this.metricRecorder != null ? OrcaMetricReportingServerInterceptor.fromInternalReport(InternalMetricRecorder.getMetricReport(OrcaMetricReportingServerInterceptor.this.metricRecorder)) : OrcaLoadReport.newBuilder();
                OrcaMetricReportingServerInterceptor.mergeMetrics(reportBuilder, InternalCallMetricRecorder.finalizeAndDump2(finalCallMetricRecorder));
                OrcaLoadReport report = reportBuilder.build();
                if (!report.equals(OrcaLoadReport.getDefaultInstance())) {
                    trailers.put(ORCA_ENDPOINT_LOAD_METRICS_KEY, report);
                }
                super.close(status, trailers);
            }
        };
        return Contexts.interceptCall(ctx, trailerAttachingCall, headers, next);
    }

    private static OrcaLoadReport.Builder fromInternalReport(MetricReport internalReport) {
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).setRpsFractional(internalReport.getQps()).putAllUtilization(internalReport.getUtilizationMetrics()).putAllRequestCost(internalReport.getRequestCostMetrics());
    }

    private static void mergeMetrics(OrcaLoadReport.Builder metricRecorderReportBuilder, MetricReport callMetricRecorderReport) {
        double rps;
        double mem;
        metricRecorderReportBuilder.putAllUtilization(callMetricRecorderReport.getUtilizationMetrics()).putAllRequestCost(callMetricRecorderReport.getRequestCostMetrics());
        double cpu = callMetricRecorderReport.getCpuUtilization();
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(cpu)) {
            metricRecorderReportBuilder.setCpuUtilization(cpu);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(mem = callMetricRecorderReport.getMemoryUtilization())) {
            metricRecorderReportBuilder.setMemUtilization(mem);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(rps = callMetricRecorderReport.getQps())) {
            metricRecorderReportBuilder.setRpsFractional(rps);
        }
    }

    private static boolean isReportValueSet(double value) {
        return value != 0.0;
    }
}

