/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageRetryStrategy;
import net.snowflake.client.jdbc.internal.google.iam.v1.GetIamPolicyRequest;
import net.snowflake.client.jdbc.internal.google.iam.v1.SetIamPolicyRequest;
import net.snowflake.client.jdbc.internal.google.iam.v1.TestIamPermissionsRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ComposeObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.CreateBucketRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.CreateHmacKeyRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.CreateNotificationConfigRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.DeleteBucketRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.DeleteHmacKeyRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.DeleteNotificationConfigRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.DeleteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.GetBucketRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.GetHmacKeyRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.GetNotificationConfigRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.GetObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.GetServiceAccountRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ListBucketsRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ListHmacKeysRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ListNotificationConfigsRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ListObjectsRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.LockBucketRetentionPolicyRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.QueryWriteStatusRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ReadObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.RewriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.StartResumableWriteRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.UpdateBucketRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.UpdateHmacKeyRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.UpdateObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectRequest;

final class GrpcRetryAlgorithmManager
implements Serializable {
    private static final long serialVersionUID = 3084833873820431477L;
    private final StorageRetryStrategy retryStrategy;

    GrpcRetryAlgorithmManager(StorageRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    ResultRetryAlgorithm<?> idempotent() {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ComposeObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateNotificationConfigRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteBucketRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteNotificationConfigRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteObjectRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetHmacKeyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetIamPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetNotificationConfigRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetServiceAccountRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListBucketsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListHmacKeysRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListNotificationConfigsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListObjectsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(LockBucketRetentionPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(QueryWriteStatusRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ReadObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(RewriteObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(SetIamPolicyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(StartResumableWriteRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(TestIamPermissionsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateBucketRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateHmacKeyRequest req) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateObjectRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(WriteObjectRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }
}

