/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class SnowflakeDatabaseMetaDataResultSet
extends SnowflakeBaseResultSet {
    ResultSet showObjectResultSet;
    Object[] nextRow;
    private boolean wasNull = false;
    protected Object[][] rows;
    protected int row = -1;
    private String queryId;
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDatabaseMetaDataResultSet.class);

    SnowflakeDatabaseMetaDataResultSet(List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, ResultSet showObjectResultSet, Statement statement) throws SQLException {
        super(statement);
        this.showObjectResultSet = showObjectResultSet;
        SFBaseSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
        SFResultSetMetaData sfset = new SFResultSetMetaData(columnNames.size(), columnNames, columnTypeNames, columnTypes, session);
        this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfset);
        this.nextRow = new Object[columnNames.size()];
    }

    SnowflakeDatabaseMetaDataResultSet(List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, Object[][] rows, Statement statement) throws SQLException {
        super(statement);
        this.rows = rows;
        SFBaseSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
        SFResultSetMetaData sfset = new SFResultSetMetaData(columnNames.size(), columnNames, columnTypeNames, columnTypes, session);
        this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfset);
        this.nextRow = new Object[columnNames.size()];
    }

    protected SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata metadataType, Object[][] rows, Statement statement) throws SQLException {
        this(metadataType.getColumnNames(), metadataType.getColumnTypeNames(), metadataType.getColumnTypes(), rows, statement);
    }

    protected SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata metadataType, Object[][] rows, Statement statement, String queryId) throws SQLException {
        this(metadataType.getColumnNames(), metadataType.getColumnTypeNames(), metadataType.getColumnTypes(), rows, statement);
        this.queryId = queryId;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean next() throws SQLException {
        logger.debug("public boolean next()", false);
        this.incrementRow();
        if (this.row < this.rows.length) {
            this.nextRow = this.rows[this.row];
            return true;
        }
        return false;
    }

    protected void incrementRow() {
        ++this.row;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.getStatement().close();
        }
        catch (SQLException ex) {
            logger.debug("failed to close", ex);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        logger.debug("public boolean isFirst()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.row == 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        logger.debug("public boolean isBeforeFirst()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.row == -1;
    }

    @Override
    public boolean isLast() throws SQLException {
        logger.debug("public boolean isLast()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return !this.isBeforeFirst() && this.row == this.rows.length - 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        logger.debug("public boolean isAfterLast()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.row == this.rows.length;
    }

    @Override
    public int getRow() throws SQLException {
        logger.debug("public int getRow()", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.row;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        String str = this.getString(columnIndex);
        if (str != null) {
            return str.getBytes(StandardCharsets.UTF_8);
        }
        throw new SQLException("Cannot get bytes on null column");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Time) {
            return (Time)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "TIME", obj);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "TIMESTAMP", obj);
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "DATE", obj);
    }

    static ResultSet getEmptyResult(DBMetadataResultSetMetadata metadataType, Statement statement, String queryId) throws SQLException {
        return new SnowflakeDatabaseMetaDataResultSet(metadataType, new Object[0][], statement, queryId);
    }

    static ResultSet getEmptyResultSet(DBMetadataResultSetMetadata metadataType, Statement statement) throws SQLException {
        return new SnowflakeDatabaseMetaDataResultSet(metadataType, new Object[0][], statement);
    }

    Object getObjectInternal(int columnIndex) throws SQLException {
        logger.debug("public Object getObjectInternal(int columnIndex)", false);
        this.raiseSQLExceptionIfResultSetIsClosed();
        if (this.nextRow == null) {
            throw new SQLException("No row found.");
        }
        if (columnIndex > this.nextRow.length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        this.wasNull = this.nextRow[columnIndex - 1] == null;
        logger.debug("Returning column: " + columnIndex + ": " + this.nextRow[columnIndex - 1], new Object[0]);
        return this.nextRow[columnIndex - 1];
    }

    @Override
    public boolean wasNull() throws SQLException {
        logger.debug("public boolean wasNull() returning {}", this.wasNull);
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        logger.debug("public String getString(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        return obj == null ? null : obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        logger.debug("public boolean getBoolean(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (obj.toString().equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (obj instanceof Integer) {
            int i = (Integer)obj;
            if (i > 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return (Boolean)obj;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        logger.debug("public byte getByte(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Byte.valueOf((String)obj);
        }
        return (Byte)obj;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        logger.debug("public short getShort(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Short.valueOf((String)obj);
        }
        return ((Number)obj).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        logger.debug("public int getInt(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        return ((Number)obj).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        logger.debug("public long getLong(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return Long.valueOf((String)obj);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid long: " + (String)obj);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        logger.debug("public float getFloat(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof String) {
            return Float.valueOf((String)obj).floatValue();
        }
        return ((Number)obj).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        logger.debug("public double getDouble(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return ((Number)obj).doubleValue();
    }

    public String getQueryID() {
        return this.queryId;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex, int scale)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        BigDecimal value = obj instanceof String ? new BigDecimal((String)obj) : new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)", false);
        BigDecimal value = null;
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        value = obj instanceof String ? new BigDecimal((String)obj) : new BigDecimal(obj.toString());
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        logger.debug("public Object getObject(int columnIndex)", false);
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object internalObj = this.getObjectInternal(columnIndex);
        if (internalObj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }
}

