/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpTransport;
import net.snowflake.client.jdbc.internal.google.api.client.http.javanet.NetHttpTransport;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.gax.core.BackgroundResource;
import net.snowflake.client.jdbc.internal.google.api.gax.core.InstantiatingExecutorProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMethodDescriptor;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallOptions;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonChannel;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonClientCall;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonClientCallImpl;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@BetaApi
public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private static final ExecutorService DEFAULT_EXECUTOR = InstantiatingExecutorProvider.newBuilder().build().getExecutor();
    private final Executor executor;
    private final String endpoint;
    private final HttpTransport httpTransport;
    private boolean isTransportShutdown;

    protected ManagedHttpJsonChannel() {
        this(null, null, null);
    }

    private ManagedHttpJsonChannel(Executor executor, String endpoint, @Nullable HttpTransport httpTransport) {
        this.executor = executor;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
    }

    @Override
    public <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpJsonCallOptions callOptions) {
        return new HttpJsonClientCallImpl<RequestT, ResponseT>(methodDescriptor, this.endpoint, callOptions, this.httpTransport, this.executor);
    }

    @Override
    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isTransportShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isTransportShutdown;
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void close() {
    }

    public static Builder newBuilder() {
        return new Builder().setExecutor(DEFAULT_EXECUTOR);
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private HttpTransport httpTransport;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull(this.endpoint);
            return new ManagedHttpJsonChannel(this.executor, this.endpoint, this.httpTransport == null ? new NetHttpTransport() : this.httpTransport);
        }
    }
}

