/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Int;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.KeyValue;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Collections2;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TypeLayout;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ExtensionTypeRegistry;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonCreator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonIgnore;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonInclude;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.client.jdbc.internal.google.flatbuffers.FlatBufferBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Field {
    private static final Logger logger = LoggerFactory.getLogger(Field.class);
    private final String name;
    private final FieldType fieldType;
    private final List<Field> children;

    public static Field nullablePrimitive(String name, ArrowType.PrimitiveType type) {
        return Field.nullable(name, type);
    }

    public static Field nullable(String name, ArrowType type) {
        return new Field(name, FieldType.nullable(type), null);
    }

    public static Field notNullable(String name, ArrowType type) {
        return new Field(name, FieldType.notNullable(type), null);
    }

    private Field(String name, boolean nullable, ArrowType type, DictionaryEncoding dictionary, List<Field> children, Map<String, String> metadata) {
        this(name, new FieldType(nullable, type, dictionary, metadata), children);
    }

    @JsonCreator
    private Field(@JsonProperty(value="name") String name, @JsonProperty(value="nullable") boolean nullable, @JsonProperty(value="type") ArrowType type, @JsonProperty(value="dictionary") DictionaryEncoding dictionary, @JsonProperty(value="children") List<Field> children, @JsonProperty(value="metadata") List<Map<String, String>> metadata) {
        this(name, new FieldType(nullable, type, dictionary, Schema.convertMetadata(metadata)), children);
    }

    private Field(String name, FieldType fieldType, List<Field> children, TypeLayout typeLayout) {
        this.name = name;
        this.fieldType = Preconditions.checkNotNull(fieldType);
        this.children = children == null ? Collections.emptyList() : Collections2.toImmutableList(children);
    }

    public Field(String name, FieldType fieldType, List<Field> children) {
        this(name, fieldType, children, fieldType == null ? null : TypeLayout.getTypeLayout(fieldType.getType()));
    }

    public FieldVector createVector(BufferAllocator allocator) {
        FieldVector vector = this.fieldType.createNewSingleVector(this, allocator, null);
        vector.initializeChildrenFromFields(this.children);
        return vector;
    }

    public static Field convertField(net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field field) {
        Map<String, String> metadata = new HashMap();
        for (int i = 0; i < field.customMetadataLength(); ++i) {
            KeyValue kv = field.customMetadata(i);
            String key = kv.key();
            String value = kv.value();
            metadata.put(key == null ? "" : key, value == null ? "" : value);
        }
        metadata = Collections.unmodifiableMap(metadata);
        String name = field.name();
        boolean nullable = field.nullable();
        ArrowType type = ArrowType.getTypeForField(field);
        if (metadata.containsKey("ARROW:extension:name")) {
            String extensionName = (String)metadata.get("ARROW:extension:name");
            String extensionMetadata = metadata.getOrDefault("ARROW:extension:metadata", "");
            ArrowType.ExtensionType extensionType = ExtensionTypeRegistry.lookup(extensionName);
            if (extensionType != null) {
                type = extensionType.deserialize(type, extensionMetadata);
            } else {
                logger.info("Unrecognized extension type: {}", (Object)extensionName);
            }
        }
        DictionaryEncoding dictionary = null;
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding dictionaryFB = field.dictionary();
        if (dictionaryFB != null) {
            ArrowType.Int indexType = null;
            Int indexTypeFB = dictionaryFB.indexType();
            if (indexTypeFB != null) {
                indexType = new ArrowType.Int(indexTypeFB.bitWidth(), indexTypeFB.isSigned());
            }
            dictionary = new DictionaryEncoding(dictionaryFB.id(), dictionaryFB.isOrdered(), indexType);
        }
        List<Field> children = new ArrayList();
        for (int i = 0; i < field.childrenLength(); ++i) {
            Field childField = Field.convertField(field.children(i));
            childField = Field.mutateOriginalNameIfNeeded(field, childField);
            children.add(childField);
        }
        children = Collections.unmodifiableList(children);
        return new Field(name, nullable, type, dictionary, children, metadata);
    }

    private static Field mutateOriginalNameIfNeeded(net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field field, Field originalChildField) {
        if ((field.typeType() == 12 || field.typeType() == 16) && originalChildField.getName().equals("[DEFAULT]")) {
            return new Field("$data$", originalChildField.isNullable(), originalChildField.getType(), originalChildField.getDictionary(), originalChildField.getChildren(), originalChildField.getMetadata());
        }
        return originalChildField;
    }

    public int getField(FlatBufferBuilder builder) {
        int nameOffset = this.name == null ? -1 : builder.createString(this.name);
        int typeOffset = this.getType().getType(builder);
        int dictionaryOffset = -1;
        DictionaryEncoding dictionary = this.getDictionary();
        if (dictionary != null) {
            int dictionaryType = dictionary.getIndexType().getType(builder);
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding.startDictionaryEncoding(builder);
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding.addId(builder, dictionary.getId());
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding.addIsOrdered(builder, dictionary.isOrdered());
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding.addIndexType(builder, dictionaryType);
            dictionaryOffset = net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryEncoding.endDictionaryEncoding(builder);
        }
        int[] childrenData = new int[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            childrenData[i] = this.children.get(i).getField(builder);
        }
        int childrenOffset = net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.createChildrenVector(builder, childrenData);
        int[] metadataOffsets = new int[this.getMetadata().size()];
        Iterator<Map.Entry<String, String>> metadataIterator = this.getMetadata().entrySet().iterator();
        for (int i = 0; i < metadataOffsets.length; ++i) {
            Map.Entry<String, String> kv = metadataIterator.next();
            int keyOffset = builder.createString(kv.getKey());
            int valueOffset = builder.createString(kv.getValue());
            KeyValue.startKeyValue(builder);
            KeyValue.addKey(builder, keyOffset);
            KeyValue.addValue(builder, valueOffset);
            metadataOffsets[i] = KeyValue.endKeyValue(builder);
        }
        int metadataOffset = net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.createCustomMetadataVector(builder, metadataOffsets);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.startField(builder);
        if (this.name != null) {
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addName(builder, nameOffset);
        }
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addNullable(builder, this.isNullable());
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addTypeType(builder, this.getType().getTypeID().getFlatbufID());
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addType(builder, typeOffset);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addChildren(builder, childrenOffset);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addCustomMetadata(builder, metadataOffset);
        if (dictionary != null) {
            net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.addDictionary(builder, dictionaryOffset);
        }
        return net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.endField(builder);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.fieldType.isNullable();
    }

    public ArrowType getType() {
        return this.fieldType.getType();
    }

    @JsonIgnore
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DictionaryEncoding getDictionary() {
        return this.fieldType.getDictionary();
    }

    public List<Field> getChildren() {
        return this.children;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return this.fieldType.getMetadata();
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    List<Map<String, String>> getMetadataForJson() {
        return Schema.convertMetadata(this.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isNullable(), this.getType(), this.getDictionary(), this.getMetadata(), this.children);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        Field that = (Field)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.isNullable(), that.isNullable()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getDictionary(), that.getDictionary()) && Objects.equals(this.getMetadata(), that.getMetadata()) && Objects.equals(this.children, that.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name).append(": ");
        }
        sb.append(this.getType());
        if (this.getDictionary() != null) {
            sb.append("[dictionary: ").append(this.getDictionary().getId()).append("]");
        }
        if (!this.children.isEmpty()) {
            sb.append("<").append(this.children.stream().map(t2 -> t2.toString()).collect(Collectors.joining(", "))).append(">");
        }
        if (!this.isNullable()) {
            sb.append(" not null");
        }
        return sb.toString();
    }
}

