/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.LoggingOperations;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageLocation;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageUri;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics.LogBlobIterable;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics.LogRecord;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics.LogRecordIterable;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics.StorageService;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobListingDetails;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobRequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobDirectory;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.ListBlobItem;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.CloudTable;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.CloudTableClient;

public class CloudAnalyticsClient {
    protected final CloudBlobClient blobClient;
    protected final CloudTableClient tableClient;
    protected String LogContainer = "$logs";

    public CloudAnalyticsClient(StorageUri blobStorageUri, StorageUri tableStorageUri, StorageCredentials credentials) {
        Utility.assertNotNull("blobStorageUri", blobStorageUri);
        Utility.assertNotNull("tableStorageUri", tableStorageUri);
        this.blobClient = new CloudBlobClient(blobStorageUri, credentials);
        this.tableClient = new CloudTableClient(tableStorageUri, credentials);
    }

    public CloudBlobDirectory getLogDirectory(StorageService service) throws URISyntaxException, StorageException {
        Utility.assertNotNull("service", (Object)service);
        return this.blobClient.getContainerReference(this.LogContainer).getDirectoryReference(service.toString().toLowerCase(Locale.US));
    }

    public CloudTable getHourMetricsTable(StorageService service) throws URISyntaxException, StorageException {
        return this.getHourMetricsTable(service, null);
    }

    public CloudTable getHourMetricsTable(StorageService service, StorageLocation location) throws URISyntaxException, StorageException {
        Utility.assertNotNull("service", (Object)service);
        if (location == null) {
            location = StorageLocation.PRIMARY;
        }
        switch (service) {
            case BLOB: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsHourPrimaryTransactionsBlob");
                }
                return this.tableClient.getTableReference("$MetricsHourSecondaryTransactionsBlob");
            }
            case FILE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsHourPrimaryTransactionsFile");
                }
                return this.tableClient.getTableReference("$MetricsHourSecondaryTransactionsFile");
            }
            case QUEUE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsHourPrimaryTransactionsQueue");
                }
                return this.tableClient.getTableReference("$MetricsHourSecondaryTransactionsQueue");
            }
            case TABLE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsHourPrimaryTransactionsTable");
                }
                return this.tableClient.getTableReference("$MetricsHourSecondaryTransactionsTable");
            }
        }
        throw new IllegalArgumentException("Invalid storage service specified.");
    }

    public CloudTable getMinuteMetricsTable(StorageService service) throws URISyntaxException, StorageException {
        return this.getMinuteMetricsTable(service, null);
    }

    public CloudTable getMinuteMetricsTable(StorageService service, StorageLocation location) throws URISyntaxException, StorageException {
        Utility.assertNotNull("service", (Object)service);
        if (location == null) {
            location = StorageLocation.PRIMARY;
        }
        switch (service) {
            case BLOB: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsMinutePrimaryTransactionsBlob");
                }
                return this.tableClient.getTableReference("$MetricsMinuteSecondaryTransactionsBlob");
            }
            case FILE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsMinutePrimaryTransactionsFile");
                }
                return this.tableClient.getTableReference("$MetricsMinuteSecondaryTransactionsFile");
            }
            case QUEUE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsMinutePrimaryTransactionsQueue");
                }
                return this.tableClient.getTableReference("$MetricsMinuteSecondaryTransactionsQueue");
            }
            case TABLE: {
                if (location == StorageLocation.PRIMARY) {
                    return this.tableClient.getTableReference("$MetricsMinutePrimaryTransactionsTable");
                }
                return this.tableClient.getTableReference("$MetricsMinuteSecondaryTransactionsTable");
            }
        }
        throw new IllegalArgumentException("Invalid storage service specified.");
    }

    public CloudTable getCapacityTable() throws URISyntaxException, StorageException {
        return this.tableClient.getTableReference("$MetricsCapacityBlob");
    }

    public Iterable<ListBlobItem> listLogBlobs(StorageService service) throws URISyntaxException, StorageException {
        return this.listLogBlobs(service, null, null, null, null, null, null);
    }

    public Iterable<ListBlobItem> listLogBlobs(StorageService service, Date startTime, Date endTime, EnumSet<LoggingOperations> operations, BlobListingDetails details, BlobRequestOptions options, OperationContext operationContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("service", (Object)service);
        if (operations == null) {
            operations = EnumSet.allOf(LoggingOperations.class);
        }
        if (details != null && !details.equals((Object)BlobListingDetails.METADATA)) {
            throw new IllegalArgumentException("Invalid blob listing details specified.");
        }
        if (operations.equals(EnumSet.noneOf(LoggingOperations.class))) {
            throw new IllegalArgumentException("Invalid logging operations specified.");
        }
        EnumSet<BlobListingDetails> metadataDetails = details != null && (details.equals((Object)BlobListingDetails.METADATA) || !operations.equals(EnumSet.allOf(LoggingOperations.class))) ? EnumSet.of(BlobListingDetails.METADATA) : EnumSet.noneOf(BlobListingDetails.class);
        return new LogBlobIterable(this.getLogDirectory(service), startTime, endTime, operations, metadataDetails, options, operationContext);
    }

    public Iterable<LogRecord> listLogRecords(StorageService service) throws URISyntaxException, StorageException {
        return this.listLogRecords(service, null, null, null, null);
    }

    public Iterable<LogRecord> listLogRecords(StorageService service, Date startTime, Date endTime, BlobRequestOptions options, OperationContext operationContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("service", (Object)service);
        EnumSet<LoggingOperations> operations = EnumSet.allOf(LoggingOperations.class);
        EnumSet<BlobListingDetails> metadataDetails = EnumSet.noneOf(BlobListingDetails.class);
        Iterator<ListBlobItem> blobIterator = new LogBlobIterable(this.getLogDirectory(service), startTime, endTime, operations, metadataDetails, options, operationContext).iterator();
        return new LogRecordIterable(blobIterator);
    }

    public static Iterable<LogRecord> parseLogBlobs(Iterable<ListBlobItem> logBlobs) {
        Utility.assertNotNull("logBlobs", logBlobs);
        return new LogRecordIterable(logBlobs.iterator());
    }

    public static Iterable<LogRecord> parseLogBlob(ListBlobItem logBlob) {
        Utility.assertNotNull("logBlob", logBlob);
        ArrayList<ListBlobItem> blobWrapper = new ArrayList<ListBlobItem>();
        blobWrapper.add(logBlob);
        return new LogRecordIterable(blobWrapper.iterator());
    }
}

