/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.Bucket;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpMethod;
import net.snowflake.client.jdbc.internal.google.common.base.Function;
import net.snowflake.client.jdbc.internal.google.common.base.Functions;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.Iterables;
import net.snowflake.client.jdbc.internal.google.common.collect.Lists;

public final class Cors
implements Serializable {
    private static final long serialVersionUID = -8637770919343335655L;
    static final Function<Bucket.Cors, Cors> FROM_PB_FUNCTION = new Function<Bucket.Cors, Cors>(){

        @Override
        public Cors apply(Bucket.Cors pb) {
            return Cors.fromPb(pb);
        }
    };
    static final Function<Cors, Bucket.Cors> TO_PB_FUNCTION = new Function<Cors, Bucket.Cors>(){

        @Override
        public Bucket.Cors apply(Cors cors) {
            return cors.toPb();
        }
    };
    private final Integer maxAgeSeconds;
    private final ImmutableList<HttpMethod> methods;
    private final ImmutableList<Origin> origins;
    private final ImmutableList<String> responseHeaders;

    private Cors(Builder builder) {
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.methods = builder.methods;
        this.origins = builder.origins;
        this.responseHeaders = builder.responseHeaders;
    }

    public Integer getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public List<HttpMethod> getMethods() {
        return this.methods;
    }

    public List<Origin> getOrigins() {
        return this.origins;
    }

    public List<String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Builder toBuilder() {
        return Cors.newBuilder().setMaxAgeSeconds(this.maxAgeSeconds).setMethods(this.methods).setOrigins(this.origins).setResponseHeaders(this.responseHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.maxAgeSeconds, this.methods, this.origins, this.responseHeaders);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors)obj;
        return Objects.equals(this.maxAgeSeconds, other.maxAgeSeconds) && Objects.equals(this.methods, other.methods) && Objects.equals(this.origins, other.origins) && Objects.equals(this.responseHeaders, other.responseHeaders);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    Bucket.Cors toPb() {
        Bucket.Cors pb = new Bucket.Cors();
        pb.setMaxAgeSeconds(this.maxAgeSeconds);
        pb.setResponseHeader(this.responseHeaders);
        if (this.methods != null) {
            pb.setMethod(Lists.newArrayList(Iterables.transform(this.methods, Functions.toStringFunction())));
        }
        if (this.origins != null) {
            pb.setOrigin(Lists.newArrayList(Iterables.transform(this.origins, Functions.toStringFunction())));
        }
        return pb;
    }

    static Cors fromPb(Bucket.Cors cors) {
        Builder builder = Cors.newBuilder().setMaxAgeSeconds(cors.getMaxAgeSeconds());
        if (cors.getMethod() != null) {
            builder.setMethods(Iterables.transform(cors.getMethod(), new Function<String, HttpMethod>(){

                @Override
                public HttpMethod apply(String name) {
                    return HttpMethod.valueOf(name.toUpperCase());
                }
            }));
        }
        if (cors.getOrigin() != null) {
            builder.setOrigins(Iterables.transform(cors.getOrigin(), new Function<String, Origin>(){

                @Override
                public Origin apply(String value) {
                    return Origin.of(value);
                }
            }));
        }
        builder.setResponseHeaders(cors.getResponseHeader());
        return builder.build();
    }

    public static final class Builder {
        private Integer maxAgeSeconds;
        private ImmutableList<HttpMethod> methods;
        private ImmutableList<Origin> origins;
        private ImmutableList<String> responseHeaders;

        private Builder() {
        }

        public Builder setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public Builder setMethods(Iterable<HttpMethod> methods) {
            this.methods = methods != null ? ImmutableList.copyOf(methods) : null;
            return this;
        }

        public Builder setOrigins(Iterable<Origin> origins) {
            this.origins = origins != null ? ImmutableList.copyOf(origins) : null;
            return this;
        }

        public Builder setResponseHeaders(Iterable<String> headers) {
            this.responseHeaders = headers != null ? ImmutableList.copyOf(headers) : null;
            return this;
        }

        public Cors build() {
            return new Cors(this);
        }
    }

    public static final class Origin
    implements Serializable {
        private static final long serialVersionUID = -4447958124895577993L;
        private static final String ANY_URI = "*";
        private final String value;
        private static final Origin ANY = new Origin("*");

        private Origin(String value) {
            this.value = Preconditions.checkNotNull(value);
        }

        public static Origin any() {
            return ANY;
        }

        public static Origin of(String scheme, String host, int port) {
            try {
                return Origin.of(new URI(scheme, null, host, port, null, null, null).toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static Origin of(String value) {
            if (ANY_URI.equals(value)) {
                return Origin.any();
            }
            return new Origin(value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Origin)) {
                return false;
            }
            return this.value.equals(((Origin)obj).value);
        }

        public String toString() {
            return this.getValue();
        }

        public String getValue() {
            return this.value;
        }
    }
}

