/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.StructuredPojo;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.MultiRegionConfiguration;

@SdkInternalApi
public class MultiRegionConfigurationMarshaller {
    private static final MarshallingInfo<String> MULTIREGIONKEYTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiRegionKeyType").build();
    private static final MarshallingInfo<StructuredPojo> PRIMARYKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryKey").build();
    private static final MarshallingInfo<List> REPLICAKEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaKeys").build();
    private static final MultiRegionConfigurationMarshaller instance = new MultiRegionConfigurationMarshaller();

    public static MultiRegionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MultiRegionConfiguration multiRegionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (multiRegionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(multiRegionConfiguration.getMultiRegionKeyType(), MULTIREGIONKEYTYPE_BINDING);
            protocolMarshaller.marshall(multiRegionConfiguration.getPrimaryKey(), PRIMARYKEY_BINDING);
            protocolMarshaller.marshall(multiRegionConfiguration.getReplicaKeys(), REPLICAKEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

