/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.json.GoogleJsonError;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Blob;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobId;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Option;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageBatchResult;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.RpcBatch;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;

public class StorageBatch {
    private final RpcBatch batch;
    private final StorageRpc storageRpc;
    private final StorageOptions options;

    StorageBatch(StorageOptions options) {
        this.options = options;
        this.storageRpc = options.getStorageRpcV1();
        this.batch = this.storageRpc.createBatch();
    }

    @VisibleForTesting
    Object getBatch() {
        return this.batch;
    }

    @VisibleForTesting
    StorageRpc getStorageRpc() {
        return this.storageRpc;
    }

    @VisibleForTesting
    StorageOptions getOptions() {
        return this.options;
    }

    public StorageBatchResult<Boolean> delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    public StorageBatchResult<Boolean> delete(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageBatchResult<Boolean> result = new StorageBatchResult<Boolean>();
        RpcBatch.Callback<Void> callback = this.createDeleteCallback(result);
        Map<StorageRpc.Option, ?> optionMap = StorageImpl.optionMap(blob, (Option[])options);
        this.batch.addDelete(blob.toPb(), callback, optionMap);
        return result;
    }

    public StorageBatchResult<Blob> update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        StorageBatchResult<Blob> result = new StorageBatchResult<Blob>();
        RpcBatch.Callback<StorageObject> callback = this.createUpdateCallback(this.options, result);
        Map<StorageRpc.Option, ?> optionMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        this.batch.addPatch(blobInfo.toPb(), callback, optionMap);
        return result;
    }

    public StorageBatchResult<Blob> get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    public StorageBatchResult<Blob> get(BlobId blob, Storage.BlobGetOption ... options) {
        StorageBatchResult<Blob> result = new StorageBatchResult<Blob>();
        RpcBatch.Callback<StorageObject> callback = this.createGetCallback(this.options, result);
        Map<StorageRpc.Option, ?> optionMap = StorageImpl.optionMap(blob, (Option[])options);
        this.batch.addGet(blob.toPb(), callback, optionMap);
        return result;
    }

    public void submit() {
        this.batch.submit();
    }

    private RpcBatch.Callback<Void> createDeleteCallback(final StorageBatchResult<Boolean> result) {
        return new RpcBatch.Callback<Void>(){

            @Override
            public void onSuccess(Void response) {
                result.success(true);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                StorageException serviceException = new StorageException(googleJsonError);
                if (serviceException.getCode() == 404) {
                    result.success(false);
                } else {
                    result.error(serviceException);
                }
            }
        };
    }

    private RpcBatch.Callback<StorageObject> createGetCallback(final StorageOptions serviceOptions, final StorageBatchResult<Blob> result) {
        return new RpcBatch.Callback<StorageObject>(){

            @Override
            public void onSuccess(StorageObject response) {
                result.success(response == null ? null : Blob.fromPb((Storage)serviceOptions.getService(), response));
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                StorageException serviceException = new StorageException(googleJsonError);
                if (serviceException.getCode() == 404) {
                    result.success(null);
                } else {
                    result.error(serviceException);
                }
            }
        };
    }

    private RpcBatch.Callback<StorageObject> createUpdateCallback(final StorageOptions serviceOptions, final StorageBatchResult<Blob> result) {
        return new RpcBatch.Callback<StorageObject>(){

            @Override
            public void onSuccess(StorageObject response) {
                result.success(response == null ? null : Blob.fromPb((Storage)serviceOptions.getService(), response));
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError) {
                result.error(new StorageException(googleJsonError));
            }
        };
    }
}

