/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.FixedSizeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.ComplexCopier;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BaseWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.UnionHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class UnionFixedSizeListReader
extends AbstractFieldReader {
    private final FixedSizeListVector vector;
    private final ValueVector data;
    private final int listSize;
    private int currentOffset;

    public UnionFixedSizeListReader(FixedSizeListVector vector) {
        this.vector = vector;
        this.data = vector.getDataVector();
        this.listSize = vector.getListSize();
    }

    @Override
    public boolean isSet() {
        return !this.vector.isNull(this.idx());
    }

    @Override
    public FieldReader reader() {
        return this.data.getReader();
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }

    @Override
    public Types.MinorType getMinorType() {
        return this.vector.getMinorType();
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        this.data.getReader().setPosition(index * this.listSize);
        this.currentOffset = 0;
    }

    @Override
    public void read(int index, UnionHolder holder) {
        this.setPosition(this.idx());
        for (int i = -1; i < index; ++i) {
            if (this.next()) continue;
            throw new IndexOutOfBoundsException("Requested " + index + ", size " + this.listSize);
        }
        holder.reader = this.data.getReader();
        holder.isSet = this.vector.isNull(this.idx()) ? 0 : 1;
    }

    @Override
    public int size() {
        return this.listSize;
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.listSize) {
            this.data.getReader().setPosition(this.idx() * this.listSize + this.currentOffset++);
            return true;
        }
        return false;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        ComplexCopier.copy(this, (FieldWriter)writer);
    }
}

