/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.ers.ERSCachingData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.tsp.ers.ERSUtil;

public class ERSInputStreamData
extends ERSCachingData {
    private final InputStream content;

    public ERSInputStreamData(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("directory not allowed");
        }
        this.content = new FileInputStream(file);
    }

    public ERSInputStreamData(InputStream inputStream) {
        this.content = inputStream;
    }

    protected byte[] calculateHash(DigestCalculator digestCalculator) {
        return ERSUtil.calculateDigest(digestCalculator, this.content);
    }
}

