/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSCertificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSCertificateBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSPublicVerificationKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.operator.ECDSAEncoder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.operator.ITSContentSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.OEREncoder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Certificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.CertificateBase;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.CertificateId;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.CertificateType;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.HashAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.HashedId;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.IssuerIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Signature;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.ToBeSignedCertificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.VerificationKeyIndicator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.template.IEEE1609dot2;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class ITSExplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final ITSContentSigner signer;

    public ITSExplicitCertificateBuilder(ITSContentSigner iTSContentSigner, ToBeSignedCertificate.Builder builder) {
        super(builder);
        this.signer = iTSContentSigner;
    }

    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey) {
        return this.build(certificateId, iTSPublicVerificationKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey, ITSPublicEncryptionKey iTSPublicEncryptionKey) {
        Object object;
        VerificationKeyIndicator verificationKeyIndicator;
        ToBeSignedCertificate.Builder builder = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        builder.setCertificateId(certificateId);
        if (iTSPublicEncryptionKey != null) {
            builder.setEncryptionKey(iTSPublicEncryptionKey.toASN1Structure());
        }
        builder.setVerificationKeyIndicator(VerificationKeyIndicator.builder().publicVerificationKey(iTSPublicVerificationKey.toASN1Structure()).createVerificationKeyIndicator());
        ToBeSignedCertificate toBeSignedCertificate = builder.createToBeSignedCertificate();
        ToBeSignedCertificate toBeSignedCertificate2 = null;
        if (this.signer.isForSelfSigning()) {
            verificationKeyIndicator = toBeSignedCertificate.getVerificationKeyIndicator();
        } else {
            toBeSignedCertificate2 = this.signer.getAssociatedCertificate().toASN1Structure().getCertificateBase().getToBeSignedCertificate();
            verificationKeyIndicator = toBeSignedCertificate2.getVerificationKeyIndicator();
        }
        OutputStream outputStream = this.signer.getOutputStream();
        try {
            outputStream.write(OEREncoder.toByteArray(toBeSignedCertificate, IEEE1609dot2.tbsCertificate));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
        Signature signature = null;
        switch (verificationKeyIndicator.getChoice()) {
            case 0: {
                signature = ECDSAEncoder.toITS(SECObjectIdentifiers.secp256r1, this.signer.getSignature());
                break;
            }
            case 1: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP256r1, this.signer.getSignature());
                break;
            }
            case 3: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP384r1, this.signer.getSignature());
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        CertificateBase.Builder builder2 = new CertificateBase.Builder();
        IssuerIdentifier.Builder builder3 = IssuerIdentifier.builder();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signer.getDigestAlgorithm().getAlgorithm();
        if (this.signer.isForSelfSigning()) {
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                builder3.self(HashAlgorithm.sha256);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                builder3.self(HashAlgorithm.sha384);
            }
        } else {
            object = this.signer.getAssociatedCertificateDigest();
            HashedId.HashedId8 hashedId8 = new HashedId.HashedId8(Arrays.copyOfRange((byte[])object, ((byte[])object).length - 8, ((byte[])object).length));
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                builder3.sha256AndDigest(hashedId8);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                builder3.sha384AndDigest(hashedId8);
            }
        }
        builder2.setVersion(this.version);
        builder2.setType(CertificateType.Explicit);
        builder2.setIssuer(builder3.createIssuerIdentifier());
        builder2.setToBeSignedCertificate(toBeSignedCertificate);
        builder2.setSignature(signature);
        object = new Certificate.Builder();
        ((Certificate.Builder)object).setCertificateBase(builder2.createCertificateBase());
        return new ITSCertificate(((Certificate.Builder)object).createCertificate());
    }
}

