/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.retrying;

import net.snowflake.client.jdbc.internal.google.api.gax.retrying.StreamResumptionStrategy;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

public final class SimpleStreamResumptionStrategy<RequestT, ResponseT>
implements StreamResumptionStrategy<RequestT, ResponseT> {
    private boolean seenFirstResponse;

    @Override
    public StreamResumptionStrategy<RequestT, ResponseT> createNew() {
        return new SimpleStreamResumptionStrategy<RequestT, ResponseT>();
    }

    @Override
    public ResponseT processResponse(ResponseT response) {
        this.seenFirstResponse = true;
        return response;
    }

    @Override
    public RequestT getResumeRequest(RequestT originalRequest) {
        Preconditions.checkState(!this.seenFirstResponse, "Tried to resume an unresumeable stream.");
        return originalRequest;
    }

    @Override
    public boolean canResume() {
        return !this.seenFirstResponse;
    }
}

