/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import net.snowflake.client.jdbc.SnowflakeDriver;

public class SFFormatter
extends Formatter {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String CLASS_NAME_PREFIX;
    public static final String INFORMATICA_V1_CLASS_NAME_PREFIX = "com.snowflake";

    @Override
    public String format(LogRecord record) {
        StackTraceElement[] stackTraces;
        int lineNumber = -1;
        String className = record.getSourceClassName();
        String methodName = record.getSourceMethodName();
        for (StackTraceElement ste : stackTraces = Thread.currentThread().getStackTrace()) {
            if (!className.equals(ste.getClassName()) || !methodName.equals(ste.getMethodName())) continue;
            lineNumber = ste.getLineNumber();
            break;
        }
        if (className.startsWith(CLASS_NAME_PREFIX)) {
            className = "n.s.c" + className.substring(CLASS_NAME_PREFIX.length());
        } else if (className.startsWith(INFORMATICA_V1_CLASS_NAME_PREFIX)) {
            className = "c.s" + className.substring(INFORMATICA_V1_CLASS_NAME_PREFIX.length());
        }
        StringBuilder builder = new StringBuilder(1000);
        builder.append(df.format(new Date(record.getMillis()))).append(" ");
        builder.append(className).append(" ");
        builder.append(record.getLevel()).append(" ");
        builder.append(methodName).append(":");
        builder.append(lineNumber).append(" - ");
        builder.append(this.formatMessage(record));
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public String getHead(Handler h2) {
        return super.getHead(h2);
    }

    @Override
    public String getTail(Handler h2) {
        return super.getTail(h2);
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        CLASS_NAME_PREFIX = SnowflakeDriver.class.getPackage().getName().substring(0, SnowflakeDriver.class.getPackage().getName().lastIndexOf(46));
    }
}

