/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.common.util.ClassUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.util.FixedViewColumn;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(RestRequest.class);
    public static final int EXTRA_TYPES_TIMESTAMP_LTZ = 50000;
    public static final int EXTRA_TYPES_TIMESTAMP_TZ = 50001;
    public static final int EXTRA_TYPES_TIMESTAMP_NTZ = 50002;
    private static final int ID_TOKEN_EXPIRED_GS_CODE = 390110;
    private static final int SESSION_NOT_EXIST_GS_CODE = 390111;
    private static final int MASTER_TOKEN_NOTFOUND = 390113;
    private static final int MASTER_EXPIRED_GS_CODE = 390114;
    private static final int MASTER_TOKEN_INVALID_GS_CODE = 390115;
    private static final int ID_TOKEN_INVALID_LOGIN_REQUEST_GS_CODE = 390195;
    public static final String BIG_DECIMAL_STR = "big decimal";
    public static final String FLOAT_STR = "float";
    public static final String DOUBLE_STR = "double";
    public static final String BOOLEAN_STR = "boolean";
    public static final String SHORT_STR = "short";
    public static final String INT_STR = "int";
    public static final String LONG_STR = "long";
    public static final String TIME_STR = "time";
    public static final String TIMESTAMP_STR = "timestamp";
    public static final String DATE_STR = "date";
    public static final String BYTE_STR = "byte";
    public static final String BYTES_STR = "byte array";
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void checkErrorAndThrowExceptionIncludingReauth(JsonNode rootNode) throws SnowflakeSQLException {
        SnowflakeUtil.checkErrorAndThrowExceptionSub(rootNode, true);
    }

    public static void checkErrorAndThrowException(JsonNode rootNode) throws SnowflakeSQLException {
        SnowflakeUtil.checkErrorAndThrowExceptionSub(rootNode, false);
    }

    private static void checkErrorAndThrowExceptionSub(JsonNode rootNode, boolean raiseReauthenticateError) throws SnowflakeSQLException {
        String errorMessage;
        int errorCode;
        String sqlState;
        if (rootNode.path("success").asBoolean()) {
            return;
        }
        String queryId = "unknown";
        if (!rootNode.path("data").path("sqlState").isMissingNode()) {
            sqlState = rootNode.path("data").path("sqlState").asText();
            errorCode = rootNode.path("data").path("errorCode").asInt();
            queryId = rootNode.path("data").path("queryId").asText();
            errorMessage = rootNode.path("message").asText();
        } else {
            sqlState = "XX000";
            if (!rootNode.path("code").isMissingNode()) {
                errorCode = rootNode.path("code").asInt();
                errorMessage = rootNode.path("message").asText();
            } else {
                errorCode = ErrorCode.INTERNAL_ERROR.getMessageCode();
                errorMessage = "no_error_code_from_server";
                try {
                    PrintWriter writer = new PrintWriter("output.json", "UTF-8");
                    writer.print(rootNode.toString());
                }
                catch (Exception ex) {
                    logger.debug("{}", ex);
                }
            }
        }
        if (raiseReauthenticateError) {
            switch (errorCode) {
                case 390110: 
                case 390111: 
                case 390113: 
                case 390114: 
                case 390115: 
                case 390195: {
                    throw new SnowflakeReauthenticationRequest(queryId, errorMessage, sqlState, errorCode);
                }
            }
        }
        throw new SnowflakeSQLException(queryId, errorMessage, sqlState, errorCode);
    }

    public static SnowflakeColumnMetadata extractColumnMetadata(JsonNode colNode, boolean jdbcTreatDecimalAsInt, SFBaseSession session) throws SnowflakeSQLException {
        String extColTypeName;
        int colType;
        String colName = colNode.path("name").asText();
        String internalColTypeName = colNode.path("type").asText();
        boolean nullable = colNode.path("nullable").asBoolean();
        int precision = colNode.path("precision").asInt();
        int scale = colNode.path("scale").asInt();
        int length = colNode.path("length").asInt();
        boolean fixed = colNode.path("fixed").asBoolean();
        SnowflakeType baseType = SnowflakeType.fromString(internalColTypeName);
        switch (baseType) {
            case TEXT: {
                colType = 12;
                extColTypeName = "VARCHAR";
                break;
            }
            case CHAR: {
                colType = 1;
                extColTypeName = "CHAR";
                break;
            }
            case INTEGER: {
                colType = 4;
                extColTypeName = "INTEGER";
                break;
            }
            case FIXED: {
                colType = jdbcTreatDecimalAsInt && scale == 0 ? -5 : 3;
                extColTypeName = "NUMBER";
                break;
            }
            case REAL: {
                colType = 8;
                extColTypeName = "DOUBLE";
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_LTZ: {
                colType = 50000;
                extColTypeName = "TIMESTAMPLTZ";
                break;
            }
            case TIMESTAMP_NTZ: {
                colType = 93;
                extColTypeName = "TIMESTAMPNTZ";
                break;
            }
            case TIMESTAMP_TZ: {
                colType = 50001;
                extColTypeName = "TIMESTAMPTZ";
                break;
            }
            case DATE: {
                colType = 91;
                extColTypeName = "DATE";
                break;
            }
            case TIME: {
                colType = 92;
                extColTypeName = "TIME";
                break;
            }
            case BOOLEAN: {
                colType = 16;
                extColTypeName = "BOOLEAN";
                break;
            }
            case ARRAY: {
                colType = 12;
                extColTypeName = "ARRAY";
                break;
            }
            case OBJECT: {
                colType = 12;
                extColTypeName = "OBJECT";
                break;
            }
            case VARIANT: {
                colType = 12;
                extColTypeName = "VARIANT";
                break;
            }
            case BINARY: {
                colType = -2;
                extColTypeName = "BINARY";
                break;
            }
            case GEOGRAPHY: {
                colType = 12;
                extColTypeName = "GEOGRAPHY";
                JsonNode udtOutputType = colNode.path("outputType");
                if (udtOutputType.isMissingNode()) break;
                SnowflakeType outputType = SnowflakeType.fromString(udtOutputType.asText());
                switch (outputType) {
                    case OBJECT: 
                    case TEXT: {
                        colType = 12;
                        break;
                    }
                    case BINARY: {
                        colType = -2;
                    }
                }
                break;
            }
            default: {
                throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unknown column type: " + internalColTypeName);
            }
        }
        JsonNode extColTypeNameNode = colNode.path("extTypeName");
        if (!extColTypeNameNode.isMissingNode()) {
            extColTypeName = extColTypeNameNode.asText();
        }
        String colSrcDatabase = colNode.path("database").asText();
        String colSrcSchema = colNode.path("schema").asText();
        String colSrcTable = colNode.path("table").asText();
        return new SnowflakeColumnMetadata(colName, colType, nullable, length, precision, scale, extColTypeName, fixed, baseType, colSrcDatabase, colSrcSchema, colSrcTable);
    }

    static String javaTypeToSFTypeString(int javaType, SFBaseSession session) throws SnowflakeSQLException {
        return SnowflakeType.javaTypeToSFType(javaType, session).name();
    }

    static SnowflakeType javaTypeToSFType(int javaType, SFBaseSession session) throws SnowflakeSQLException {
        return SnowflakeType.javaTypeToSFType(javaType, session);
    }

    static String concatFilePathNames(String leftPath, String rightPath, String fileSep) {
        String leftPathTrimmed = leftPath.trim();
        String rightPathTrimmed = rightPath.trim();
        if (leftPathTrimmed.isEmpty()) {
            return rightPath;
        }
        if (leftPathTrimmed.endsWith(fileSep) && rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + rightPathTrimmed.substring(1);
        }
        if (!leftPathTrimmed.endsWith(fileSep) && !rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + fileSep + rightPathTrimmed;
        }
        return leftPathTrimmed + rightPathTrimmed;
    }

    static String greatestCommonPrefix(String val1, String val2) {
        if (val1 == null || val2 == null) {
            return null;
        }
        StringBuilder greatestCommonPrefix = new StringBuilder();
        int len = Math.min(val1.length(), val2.length());
        for (int idx = 0; idx < len && val1.charAt(idx) == val2.charAt(idx); ++idx) {
            greatestCommonPrefix.append(val1.charAt(idx));
        }
        return greatestCommonPrefix.toString();
    }

    static List<SnowflakeColumnMetadata> describeFixedViewColumns(Class<?> clazz, SFBaseSession session) throws SnowflakeSQLException {
        Field[] columns = ClassUtil.getAnnotatedDeclaredFields(clazz, FixedViewColumn.class, true);
        Arrays.sort(columns, new FixedViewColumn.OrdinalComparatorForFields());
        ArrayList<SnowflakeColumnMetadata> rowType = new ArrayList<SnowflakeColumnMetadata>();
        for (Field column : columns) {
            String typeName;
            int colType;
            FixedViewColumn columnAnnotation = column.getAnnotation(FixedViewColumn.class);
            Class<?> type = column.getType();
            SnowflakeType stype = SnowflakeType.TEXT;
            if (type == Integer.TYPE) {
                colType = 4;
                typeName = "INTEGER";
                stype = SnowflakeType.INTEGER;
            }
            if (type == Long.TYPE) {
                colType = 3;
                typeName = "DECIMAL";
                stype = SnowflakeType.INTEGER;
            } else if (type == String.class) {
                colType = 12;
                typeName = "VARCHAR";
                stype = SnowflakeType.TEXT;
            } else {
                throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unsupported column type: " + type.getName());
            }
            rowType.add(new SnowflakeColumnMetadata(columnAnnotation.name(), colType, false, 20480, 10, 0, typeName, true, stype, "", "", ""));
        }
        return rowType;
    }

    public static void logResponseDetails(HttpResponse response, SFLogger logger) {
        Header[] headers;
        if (response == null) {
            logger.error("null response");
            return;
        }
        if (response.getStatusLine() != null) {
            logger.error("Response status line reason: {}", response.getStatusLine().getReasonPhrase());
        }
        if ((headers = response.getAllHeaders()) != null) {
            for (Header header : headers) {
                logger.debug("Header name: {}, value: {}", header.getName(), header.getValue());
            }
        }
        if (response.getEntity() != null) {
            try {
                StringWriter writer = new StringWriter();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                IOUtils.copy((Reader)bufferedReader, (Writer)writer);
                logger.error("Response content: {}", writer.toString());
            }
            catch (IOException ex) {
                logger.error("Failed to read content due to exception: {}", ex.getMessage());
            }
        }
    }

    public static ThreadPoolExecutor createDefaultExecutorService(final String threadNamePrefix, int parallel) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(threadNamePrefix + this.threadCount++);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(parallel, threadFactory);
    }

    public static Throwable getRootCause(Exception ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static boolean isBlank(String input) {
        if ("".equals(input) || input == null) {
            return true;
        }
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        Random random = new Random();
        while (count-- != 0) {
            int character = random.nextInt(ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public static String systemGetProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            logger.debug("Security exception raised: {}", ex.getMessage());
            return null;
        }
    }

    public static String systemGetEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (SecurityException ex) {
            logger.debug("Failed to get environment variable {}. Security exception raised: {}", env, ex.getMessage());
            return null;
        }
    }

    public static void systemSetEnv(String key, String value) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.put(key, value);
        }
        catch (Exception e) {
            System.out.println("Failed to set value");
            logger.error("Failed to set environment variable {}. Exception raised: {}", key, e.getMessage());
        }
    }

    public static void systemUnsetEnv(String key) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.remove(key);
        }
        catch (Exception e) {
            System.out.println("Failed to unset value");
            logger.error("Failed to remove environment variable {}. Exception raised: {}", key, e.getMessage());
        }
    }

    public static HttpClientSettingsKey convertProxyPropertiesToHttpClientKey(OCSPMode mode, Properties info) throws SnowflakeSQLException {
        Boolean useProxy;
        if (info != null && info.size() > 0 && info.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(info.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = info.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(info.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            String proxyUser = info.getProperty(SFSessionProperty.PROXY_USER.getPropertyKey());
            String proxyPassword = info.getProperty(SFSessionProperty.PROXY_PASSWORD.getPropertyKey());
            String nonProxyHosts = info.getProperty(SFSessionProperty.NON_PROXY_HOSTS.getPropertyKey());
            String proxyProtocol = info.getProperty(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey());
            return new HttpClientSettingsKey(mode, proxyHost, proxyPort, nonProxyHosts, proxyUser, proxyPassword, proxyProtocol);
        }
        return new HttpClientSettingsKey(mode);
    }

    public static long getSecondsFromMillis(long millis) {
        long returnVal;
        if (millis < 0L) {
            returnVal = (long)Math.ceil((double)Math.abs(millis) / 1000.0);
            returnVal *= -1L;
        } else {
            returnVal = millis / 1000L;
        }
        return returnVal;
    }
}

