/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeTimeWithTimezone;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BigIntToTimestampNTZConverter
extends AbstractArrowVectorConverter {
    private BigIntVector bigIntVector;
    private static final TimeZone NTZ = TimeZone.getTimeZone("UTC");
    private ByteBuffer byteBuf = ByteBuffer.allocate(8);

    public BigIntToTimestampNTZConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIMESTAMP_NTZ.name(), fieldVector, columnIndex, context);
        this.bigIntVector = (BigIntVector)fieldVector;
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimestampNTZFormatter() == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.context.getSession(), new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp NTZ formatter"), null, null);
        }
        Timestamp ts = this.isNull(index) ? null : this.getTimestamp(index, TimeZone.getDefault(), true);
        return ts == null ? null : this.context.getTimestampNTZFormatter().format(ts, TimeZone.getTimeZone("UTC"), this.context.getScale(this.columnIndex));
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putLong(0, this.bigIntVector.getDataBuffer().getLong(index * 8));
        return this.byteBuf.array();
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toTimestamp(index, TimeZone.getDefault());
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        return this.isNull(index) ? null : this.getTimestamp(index, tz, false);
    }

    private Timestamp getTimestamp(int index, TimeZone tz, boolean fromToString) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
        int scale = this.context.getScale(this.columnIndex);
        Timestamp ts = ArrowResultUtil.toJavaTimestamp(val, scale);
        if (!fromToString && this.context.getHonorClientTZForTimestampNTZ()) {
            ts = ArrowResultUtil.moveToTimeZone(ts, NTZ, tz);
        }
        Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(ts);
        return adjustedTimestamp;
    }

    @Override
    public Date toDate(int index, TimeZone tz, boolean dateFormat) throws SFException {
        return this.isNull(index) ? null : new Date(this.getTimestamp(index, TimeZone.getDefault(), false).getTime());
    }

    @Override
    public Time toTime(int index) throws SFException {
        Timestamp ts = this.toTimestamp(index, TimeZone.getDefault());
        return ts == null ? null : new SnowflakeTimeWithTimezone(ts.getTime(), ts.getNanos(), this.useSessionTimezone);
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        Timestamp val = this.toTimestamp(index, TimeZone.getDefault());
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }
}

