/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util;

import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMethod;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod annotatedMethod) {
        String string = annotatedMethod.getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod, string);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string);
        }
        return string2;
    }

    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return BeanUtil.manglePropertyName(string.substring(3));
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string) {
        if (string.startsWith("is")) {
            Class<?> clazz = annotatedMethod.getRawType();
            if (clazz != Boolean.class && clazz != Boolean.TYPE) {
                return null;
            }
            return BeanUtil.manglePropertyName(string.substring(2));
        }
        return null;
    }

    public static String okNameForSetter(AnnotatedMethod annotatedMethod) {
        String string = BeanUtil.okNameForMutator(annotatedMethod, "set");
        if (string != null) {
            if ("metaClass".equals(string) && BeanUtil.isGroovyMetaClassSetter(annotatedMethod)) {
                return null;
            }
            return string;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string) {
        String string2 = annotatedMethod.getName();
        if (string2.startsWith(string)) {
            return BeanUtil.manglePropertyName(string2.substring(string.length()));
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        String string;
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || !clazz.isArray()) {
            return false;
        }
        Class<?> clazz2 = clazz.getComponentType();
        Package package_ = clazz2.getPackage();
        return package_ != null && ((string = package_.getName()).startsWith("net.sf.cglib") || string.startsWith("org.hibernate.repackage.cglib"));
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        Package package_ = clazz.getPackage();
        return package_ != null && package_.getName().startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || clazz.isArray()) {
            return false;
        }
        Package package_ = clazz.getPackage();
        return package_ != null && package_.getName().startsWith("groovy.lang");
    }

    protected static String manglePropertyName(String string) {
        char c;
        char c2;
        int n = string.length();
        if (n == 0) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n && (c2 = string.charAt(i)) != (c = Character.toLowerCase(c2)); ++i) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
            }
            stringBuilder.setCharAt(i, c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }
}

