/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeBaseResultSet
implements ResultSet {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeBaseResultSet.class);
    static final int[] powersOfTen = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    protected Statement statement;
    protected boolean wasNull = false;
    protected Object[] nextRow = null;
    protected SnowflakeResultSetMetaData resultSetMetaData = null;
    protected int row = 0;
    protected boolean endOfResult = false;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected TimeZone timeZone;
    protected TimeZone timeZoneUTC;
    protected SnowflakeDateTimeFormat timestampNTZFormatter;
    protected SnowflakeDateTimeFormat timestampLTZFormatter;
    protected SnowflakeDateTimeFormat timestampTZFormatter;
    protected SnowflakeDateTimeFormat dateFormatter;
    protected SnowflakeDateTimeFormat timeFormatter;
    protected boolean honorClientTZForTimestampNTZ = true;
    protected SFBinaryFormat binaryFormatter;
    protected int fetchSize = 0;
    protected int fetchDirection = 1000;
    protected long resultVersion = 0L;

    @Override
    public boolean next() throws SQLException {
        logger.debug("public boolean next()");
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Time: {} public void close()", System.currentTimeMillis());
        }
        this.nextRow = null;
        this.statement = null;
        this.resultSetMetaData = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        logger.debug("public boolean wasNull() returning {}", this.wasNull);
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        logger.debug("public String getString(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                if (obj.toString().equals("1")) {
                    return "TRUE";
                }
                if (!obj.toString().equals("0")) break;
                return "FALSE";
            }
            case 93: 
            case 50000: 
            case 50001: {
                SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
                int columnScale = this.resultSetMetaData.getScale(columnIndex);
                String timestampStr = null;
                SnowflakeDateTimeFormat formatter = columnType == 93 ? this.timestampNTZFormatter : (columnType == 50000 ? this.timestampLTZFormatter : this.timestampTZFormatter);
                if (formatter == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing timestamp formatter");
                }
                Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(sfTS.getTimestamp());
                timestampStr = formatter.format(adjustedTimestamp, sfTS.getTimeZone(), columnScale);
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting timestamp to string from: {} to: {}", obj.toString(), timestampStr);
                }
                return timestampStr;
            }
            case 91: {
                Date date = this.getDate(columnIndex, this.timeZoneUTC);
                if (this.dateFormatter == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing date formatter");
                }
                String dateStr = null;
                Date adjustedDate = ResultUtil.adjustDate(date);
                dateStr = this.dateFormatter.format((java.util.Date)adjustedDate, this.timeZoneUTC);
                if (logger.isDebugEnabled()) {
                    String prevDateStr = this.dateFormatter.format((java.util.Date)date, this.timeZoneUTC);
                    logger.debug("Adjust date from {} to {}", prevDateStr, dateStr);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting date to string from: {} to: {}", obj.toString(), dateStr);
                }
                return dateStr;
            }
            case 92: {
                SFTime sfTime = this.getSFTime(columnIndex);
                if (this.timeFormatter == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing time formatter");
                }
                int scale = this.resultSetMetaData.getScale(columnIndex);
                String timeStr = null;
                timeStr = this.timeFormatter.format(sfTime, scale);
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting time to string from: {} to: {}", obj.toString(), timeStr);
                }
                return timeStr;
            }
            case -2: {
                if (this.binaryFormatter == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "missing binary formatter");
                }
                if (this.binaryFormatter == SFBinaryFormat.HEX) {
                    return obj.toString();
                }
                SFBinary sfb = new SFBinary(this.getBytes(columnIndex));
                return this.binaryFormatter.format(sfb);
            }
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        logger.debug("public boolean getBoolean(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (obj.toString().equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return (Boolean)obj;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        logger.debug("public byte getByte(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        logger.debug("public short getShort(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Short.valueOf((String)obj);
        }
        return ((Number)obj).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        logger.debug("public int getInt(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        return ((Number)obj).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        logger.debug("public long getLong(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return Long.valueOf((String)obj);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid long: " + (String)obj);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        logger.debug("public float getFloat(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof String) {
            return Float.valueOf((String)obj).floatValue();
        }
        return ((Number)obj).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        logger.debug("public double getDouble(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return ((Number)obj).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex, int scale)");
        BigDecimal value = null;
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        value = obj instanceof String ? new BigDecimal((String)obj) : new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        logger.debug("public byte[] getBytes(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        try {
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid binary value: " + obj.toString());
        }
    }

    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        logger.debug("public Date getDate(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        try {
            if (obj == null) {
                return null;
            }
            long milliSecsSinceEpoch = Long.valueOf(obj.toString()) * 86400000L;
            SFTimestamp tsInUTC = SFTimestamp.fromDate(new Date(milliSecsSinceEpoch), 0, TimeZone.getTimeZone("UTC"));
            SFTimestamp tsInClientTZ = tsInUTC.moveToTimeZone(tz);
            if (logger.isDebugEnabled()) {
                logger.debug("getDate: tz offset = {}", tsInClientTZ.getTimeZone().getOffset(tsInClientTZ.getTime()));
            }
            return new Date(tsInClientTZ.getTime());
        }
        catch (NumberFormatException ex) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid date value: " + obj.toString());
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        SFTime sfTime = this.getSFTime(columnIndex);
        if (sfTime == null) {
            return null;
        }
        return new Time(sfTime.getFractionalSeconds(3));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }

    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
        if (sfTS == null) {
            return null;
        }
        Timestamp res = sfTS.getTimestamp();
        if (res == null) {
            return null;
        }
        if (this.honorClientTZForTimestampNTZ && this.resultSetMetaData.getInternalColumnType(columnIndex) == 93) {
            return sfTS.moveToTimeZone(tz).getTimestamp();
        }
        return res;
    }

    private BigDecimal parseSecondsSinceEpoch(String secondsSinceEpochStr, int scale) {
        BigDecimal secondsSinceEpoch = new BigDecimal(secondsSinceEpochStr);
        return secondsSinceEpoch.scaleByPowerOfTen(scale);
    }

    public SFTimestamp getSFTimestamp(int columnIndex) throws SQLException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        try {
            TimeZone tz;
            BigDecimal fractionsSinceEpoch;
            if (obj == null) {
                return null;
            }
            int scale = this.resultSetMetaData.getScale(columnIndex);
            switch (this.resultSetMetaData.getInternalColumnType(columnIndex)) {
                case 93: {
                    fractionsSinceEpoch = this.parseSecondsSinceEpoch(obj.toString(), scale);
                    tz = this.timeZoneUTC;
                    break;
                }
                case 50001: {
                    String timestampStr = obj.toString();
                    if (this.resultVersion > 0L) {
                        logger.trace("Handle timestamp with timezone new encoding: {}", timestampStr);
                        int indexForSeparator = timestampStr.indexOf(32);
                        String secondsSinceEpochStr = timestampStr.substring(0, indexForSeparator);
                        String timezoneIndexStr = timestampStr.substring(indexForSeparator + 1);
                        fractionsSinceEpoch = this.parseSecondsSinceEpoch(secondsSinceEpochStr, scale);
                        tz = SFTimestamp.convertTimezoneIndexToTimeZone(Integer.parseInt(timezoneIndexStr));
                        break;
                    }
                    logger.trace("Handle timestamp with timezone old encoding: {}", timestampStr);
                    fractionsSinceEpoch = this.parseSecondsSinceEpoch(timestampStr, scale);
                    tz = null;
                    break;
                }
                default: {
                    assert (this.resultSetMetaData.getInternalColumnType(columnIndex) == 50000);
                    fractionsSinceEpoch = this.parseSecondsSinceEpoch(obj.toString(), scale);
                    tz = this.timeZone;
                }
            }
            return SFTimestamp.fromBinary(fractionsSinceEpoch, scale, tz);
        }
        catch (NumberFormatException ex) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid timestamp value: " + obj.toString());
        }
    }

    public SFTime getSFTime(int columnIndex) throws SQLException {
        Object obj = this.getObjectInternal(columnIndex);
        try {
            if (obj == null) {
                return null;
            }
            int scale = this.resultSetMetaData.getScale(columnIndex);
            long fractionsSinceMidnight = this.parseSecondsSinceEpoch(obj.toString(), scale).longValue();
            return SFTime.fromFractionalSeconds(fractionsSinceMidnight, scale);
        }
        catch (NumberFormatException ex) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Invalid time value: " + obj.toString());
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getAsciiStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getUnicodeStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getBinaryStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        logger.debug("public String getString(String columnLabel)");
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        logger.debug("public boolean getBoolean(String columnLabel)");
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        logger.debug("public byte getByte(String columnLabel)");
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        logger.debug("public short getShort(String columnLabel)");
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        logger.debug("public int getInt(String columnLabel)");
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        logger.debug("public long getLong(String columnLabel)");
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        logger.debug("public float getFloat(String columnLabel)");
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        logger.debug("public double getDouble(String columnLabel)");
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(String columnLabel, int scale)");
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        logger.debug("public byte[] getBytes(String columnLabel)");
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        logger.debug("public Date getDate(String columnLabel)");
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        logger.debug("public Time getTime(String columnLabel)");
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        logger.debug("public Timestamp getTimestamp(String columnLabel)");
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getAsciiStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getUnicodeStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getBinaryStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("public SQLWarning getWarnings()");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("public void clearWarnings()");
    }

    @Override
    public String getCursorName() throws SQLException {
        logger.debug("public String getCursorName()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("public ResultSetMetaData getMetaData()");
        return this.resultSetMetaData;
    }

    public Object getObjectInternal(int columnIndex) throws SQLException {
        logger.debug("public Object getObjectInternal(int columnIndex)");
        if (this.nextRow == null) {
            throw new SQLException("No row found.");
        }
        if (columnIndex > this.nextRow.length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        this.wasNull = this.nextRow[columnIndex - 1] == null;
        logger.debug("Returning column: " + columnIndex + ": " + this.nextRow[columnIndex - 1]);
        return this.nextRow[columnIndex - 1];
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        logger.debug("public Object getObject(int columnIndex)");
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object internalObj = this.getObjectInternal(columnIndex);
        if (internalObj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        logger.debug("public Object getObject(String columnLabel)");
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        logger.debug("public int findColumn(String columnLabel)");
        int columnIndex = this.resultSetMetaData.getColumnIndex(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("Column not found: " + columnLabel);
        }
        return ++columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        logger.debug("public Reader getCharacterStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        logger.debug("public Reader getCharacterStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)");
        BigDecimal value = null;
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        value = obj instanceof String ? new BigDecimal((String)obj) : new BigDecimal(obj.toString());
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(String columnLabel)");
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        logger.debug("public boolean isBeforeFirst()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        logger.debug("public boolean isAfterLast()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        logger.debug("public boolean isFirst()");
        return this.row == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        logger.debug("public boolean isLast()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        logger.debug("public void beforeFirst()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        logger.debug("public void afterLast()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        logger.debug("public boolean first()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        logger.debug("public boolean last()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getRow() throws SQLException {
        logger.debug("public int getRow()");
        return this.row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        logger.debug("public boolean absolute(int row)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        logger.debug("public boolean relative(int rows)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        logger.debug("public boolean previous()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("public void setFetchDirection(int direction)");
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("public int getFetchDirection()");
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("public void setFetchSize(int rows)");
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("public int getFetchSize()");
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        logger.debug("public int getType()");
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        logger.debug("public int getConcurrency()");
        throw new SQLFeatureNotSupportedException("Feature not supported", ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        logger.debug("public boolean rowUpdated()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        logger.debug("public boolean rowInserted()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        logger.debug("public boolean rowDeleted()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        logger.debug("public void updateNull(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        logger.debug("public void updateBoolean(int columnIndex, boolean x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        logger.debug("public void updateByte(int columnIndex, byte x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        logger.debug("public void updateShort(int columnIndex, short x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        logger.debug("public void updateInt(int columnIndex, int x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        logger.debug("public void updateLong(int columnIndex, long x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        logger.debug("public void updateFloat(int columnIndex, float x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        logger.debug("public void updateDouble(int columnIndex, double x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        logger.debug("public void updateBigDecimal(int columnIndex, BigDecimal x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        logger.debug("public void updateString(int columnIndex, String x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        logger.debug("public void updateBytes(int columnIndex, byte[] x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        logger.debug("public void updateDate(int columnIndex, Date x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        logger.debug("public void updateTime(int columnIndex, Time x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        logger.debug("public void updateTimestamp(int columnIndex, Timestamp x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        logger.debug("public void updateObject(int columnIndex, Object x, int scaleOrLength)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        logger.debug("public void updateObject(int columnIndex, Object x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        logger.debug("public void updateNull(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        logger.debug("public void updateBoolean(String columnLabel, boolean x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        logger.debug("public void updateByte(String columnLabel, byte x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        logger.debug("public void updateShort(String columnLabel, short x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        logger.debug("public void updateInt(String columnLabel, int x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        logger.debug("public void updateLong(String columnLabel, long x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        logger.debug("public void updateFloat(String columnLabel, float x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        logger.debug("public void updateDouble(String columnLabel, double x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        logger.debug("public void updateBigDecimal(String columnLabel, BigDecimal x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        logger.debug("public void updateString(String columnLabel, String x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        logger.debug("public void updateBytes(String columnLabel, byte[] x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        logger.debug("public void updateDate(String columnLabel, Date x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        logger.debug("public void updateTime(String columnLabel, Time x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        logger.debug("public void updateTimestamp(String columnLabel, Timestamp x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader,int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        logger.debug("public void updateObject(String columnLabel, Object x, int scaleOrLength)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        logger.debug("public void updateObject(String columnLabel, Object x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        logger.debug("public void insertRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        logger.debug("public void updateRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        logger.debug("public void deleteRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        logger.debug("public void refreshRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        logger.debug("public void cancelRowUpdates()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        logger.debug("public void moveToInsertRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        logger.debug("public void moveToCurrentRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        logger.debug("public Statement getStatement()");
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        logger.debug("public Object getObject(int columnIndex, Map<String, Class<?>> map)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        logger.debug("public Ref getRef(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        logger.debug("public Blob getBlob(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        logger.debug("public Clob getClob(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        logger.debug("public Array getArray(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        logger.debug("public Object getObject(String columnLabel, Map<String, Class<?>> map)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        logger.debug("public Ref getRef(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        logger.debug("public Blob getBlob(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        logger.debug("public Clob getClob(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        logger.debug("public Array getArray(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Date getDate(int columnIndex, Calendar cal)");
        return this.getDate(columnIndex, cal.getTimeZone());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Date getDate(String columnLabel, Calendar cal)");
        return this.getDate(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Time getTime(int columnIndex, Calendar cal)");
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Time getTime(String columnLabel, Calendar cal)");
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Timestamp getTimestamp(int columnIndex, Calendar cal)");
        return this.getTimestamp(columnIndex, cal.getTimeZone());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Timestamp getTimestamp(String columnLabel, Calendar cal)");
        return this.getTimestamp(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        logger.debug("public URL getURL(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        logger.debug("public URL getURL(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        logger.debug("public void updateRef(int columnIndex, Ref x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        logger.debug("public void updateRef(String columnLabel, Ref x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, Blob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, Blob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Clob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Clob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        logger.debug("public void updateArray(int columnIndex, Array x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        logger.debug("public void updateArray(String columnLabel, Array x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        logger.debug("public RowId getRowId(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        logger.debug("public RowId getRowId(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        logger.debug("public void updateRowId(int columnIndex, RowId x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        logger.debug("public void updateRowId(String columnLabel, RowId x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.debug("public int getHoldability()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("public boolean isClosed()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        logger.debug("public void updateNString(int columnIndex, String nString)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        logger.debug("public void updateNString(String columnLabel, String nString)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, NClob nClob)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, NClob nClob)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        logger.debug("public NClob getNClob(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        logger.debug("public NClob getNClob(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        logger.debug("public SQLXML getSQLXML(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        logger.debug("public SQLXML getSQLXML(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        logger.debug("public void updateSQLXML(int columnIndex, SQLXML xmlObject)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        logger.debug("public void updateSQLXML(String columnLabel, SQLXML xmlObject)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        logger.debug("public String getNString(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        logger.debug("public String getNString(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        logger.debug("public Reader getNCharacterStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        logger.debug("public Reader getNCharacterStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.debug("public void updateNCharacterStream(int columnIndex, Reader x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNCharacterStream(String columnLabel, Reader reader,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, InputStream inputStream, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, InputStream inputStream,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.debug("public void updateNCharacterStream(int columnIndex, Reader x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateNCharacterStream(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, InputStream inputStream)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, InputStream inputStream)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        logger.debug("public <T> T getObject(int columnIndex,Class<T> type)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        logger.debug("public <T> T getObject(String columnLabel,Class<T> type)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        throw new SQLFeatureNotSupportedException();
    }
}

