/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.yammer.metrics.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.org.slf4j.Logger;
import net.snowflake.client.jdbc.internal.org.slf4j.LoggerFactory;
import net.snowflake.client.jdbc.internal.yammer.metrics.Metrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Clock;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Counter;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Gauge;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Histogram;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Metered;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Metric;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.MetricName;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.MetricPredicate;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.MetricProcessor;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.MetricsRegistry;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Sampling;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Summarizable;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Timer;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.VirtualMachineMetrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.reporting.AbstractPollingReporter;
import net.snowflake.client.jdbc.internal.yammer.metrics.reporting.SocketProvider;
import net.snowflake.client.jdbc.internal.yammer.metrics.stats.Snapshot;

public class GraphiteReporter
extends AbstractPollingReporter
implements MetricProcessor<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteReporter.class);
    protected final String prefix;
    protected final MetricPredicate predicate;
    protected final Locale locale = Locale.US;
    protected final Clock clock;
    protected final SocketProvider socketProvider;
    protected final VirtualMachineMetrics vm;
    protected Writer writer;
    public boolean printVMMetrics = true;

    public static void enable(long period, TimeUnit unit, String host, int port) {
        GraphiteReporter.enable(Metrics.defaultRegistry(), period, unit, host, port);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port) {
        GraphiteReporter.enable(metricsRegistry, period, unit, host, port, null);
    }

    public static void enable(long period, TimeUnit unit, String host, int port, String prefix) {
        GraphiteReporter.enable(Metrics.defaultRegistry(), period, unit, host, port, prefix);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port, String prefix) {
        GraphiteReporter.enable(metricsRegistry, period, unit, host, port, prefix, MetricPredicate.ALL);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port, String prefix, MetricPredicate predicate) {
        try {
            GraphiteReporter reporter = new GraphiteReporter(metricsRegistry, prefix, predicate, new DefaultSocketProvider(host, port), Clock.defaultClock());
            reporter.start(period, unit);
        }
        catch (Exception e) {
            LOG.error("Error creating/starting Graphite reporter:", e);
        }
    }

    public GraphiteReporter(String host, int port, String prefix) throws IOException {
        this(Metrics.defaultRegistry(), host, port, prefix);
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String host, int port, String prefix) throws IOException {
        this(metricsRegistry, prefix, MetricPredicate.ALL, new DefaultSocketProvider(host, port), Clock.defaultClock());
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String prefix, MetricPredicate predicate, SocketProvider socketProvider, Clock clock) throws IOException {
        this(metricsRegistry, prefix, predicate, socketProvider, clock, VirtualMachineMetrics.getInstance());
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String prefix, MetricPredicate predicate, SocketProvider socketProvider, Clock clock, VirtualMachineMetrics vm) throws IOException {
        this(metricsRegistry, prefix, predicate, socketProvider, clock, vm, "graphite-reporter");
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String prefix, MetricPredicate predicate, SocketProvider socketProvider, Clock clock, VirtualMachineMetrics vm, String name) throws IOException {
        super(metricsRegistry, name);
        this.socketProvider = socketProvider;
        this.vm = vm;
        this.clock = clock;
        this.prefix = prefix != null ? prefix + "." : "";
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = this.socketProvider.get();
            this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            long epoch = this.clock.time() / 1000L;
            if (this.printVMMetrics) {
                this.printVmMetrics(epoch);
            }
            this.printRegularMetrics(epoch);
            this.writer.flush();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error writing to Graphite", e);
            } else {
                LOG.warn("Error writing to Graphite: {}", (Object)e.getMessage());
            }
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (IOException e1) {
                    LOG.error("Error while flushing writer:", e1);
                }
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.error("Error while closing socket:", e);
                }
            }
            this.writer = null;
        }
    }

    protected void printRegularMetrics(Long epoch) {
        for (Map.Entry<String, SortedMap<MetricName, Metric>> entry : this.getMetricsRegistry().groupedMetrics(this.predicate).entrySet()) {
            for (Map.Entry<MetricName, Metric> subEntry : entry.getValue().entrySet()) {
                Metric metric = subEntry.getValue();
                if (metric == null) continue;
                try {
                    metric.processWith(this, subEntry.getKey(), epoch);
                }
                catch (Exception ignored) {
                    LOG.error("Error printing regular metrics:", ignored);
                }
            }
        }
    }

    protected void sendInt(long timestamp, String name, String valueName, long value) {
        this.sendToGraphite(timestamp, name, valueName + " " + String.format(this.locale, "%d", value));
    }

    protected void sendFloat(long timestamp, String name, String valueName, double value) {
        this.sendToGraphite(timestamp, name, valueName + " " + String.format(this.locale, "%2.2f", value));
    }

    protected void sendObjToGraphite(long timestamp, String name, String valueName, Object value) {
        this.sendToGraphite(timestamp, name, valueName + " " + String.format(this.locale, "%s", value));
    }

    protected void sendToGraphite(long timestamp, String name, String value) {
        try {
            if (!this.prefix.isEmpty()) {
                this.writer.write(this.prefix);
            }
            this.writer.write(this.sanitizeString(name));
            this.writer.write(46);
            this.writer.write(value);
            this.writer.write(32);
            this.writer.write(Long.toString(timestamp));
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException e) {
            LOG.error("Error sending to Graphite:", e);
        }
    }

    protected String sanitizeName(MetricName name) {
        StringBuilder sb = new StringBuilder().append(name.getGroup()).append('.').append(name.getType()).append('.');
        if (name.hasScope()) {
            sb.append(name.getScope()).append('.');
        }
        return sb.append(name.getName()).toString();
    }

    protected String sanitizeString(String s) {
        return s.replace(' ', '-');
    }

    @Override
    public void processGauge(MetricName name, Gauge<?> gauge, Long epoch) throws IOException {
        this.sendObjToGraphite(epoch, this.sanitizeName(name), "value", gauge.value());
    }

    @Override
    public void processCounter(MetricName name, Counter counter, Long epoch) throws IOException {
        this.sendInt(epoch, this.sanitizeName(name), "count", counter.count());
    }

    @Override
    public void processMeter(MetricName name, Metered meter, Long epoch) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        this.sendInt(epoch, sanitizedName, "count", meter.count());
        this.sendFloat(epoch, sanitizedName, "meanRate", meter.meanRate());
        this.sendFloat(epoch, sanitizedName, "1MinuteRate", meter.oneMinuteRate());
        this.sendFloat(epoch, sanitizedName, "5MinuteRate", meter.fiveMinuteRate());
        this.sendFloat(epoch, sanitizedName, "15MinuteRate", meter.fifteenMinuteRate());
    }

    @Override
    public void processHistogram(MetricName name, Histogram histogram, Long epoch) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        this.sendSummarizable(epoch, sanitizedName, histogram);
        this.sendSampling(epoch, sanitizedName, histogram);
    }

    @Override
    public void processTimer(MetricName name, Timer timer, Long epoch) throws IOException {
        this.processMeter(name, (Metered)timer, epoch);
        String sanitizedName = this.sanitizeName(name);
        this.sendSummarizable(epoch, sanitizedName, timer);
        this.sendSampling(epoch, sanitizedName, timer);
    }

    protected void sendSummarizable(long epoch, String sanitizedName, Summarizable metric) throws IOException {
        this.sendFloat(epoch, sanitizedName, "min", metric.min());
        this.sendFloat(epoch, sanitizedName, "max", metric.max());
        this.sendFloat(epoch, sanitizedName, "mean", metric.mean());
        this.sendFloat(epoch, sanitizedName, "stddev", metric.stdDev());
    }

    protected void sendSampling(long epoch, String sanitizedName, Sampling metric) throws IOException {
        Snapshot snapshot = metric.getSnapshot();
        this.sendFloat(epoch, sanitizedName, "median", snapshot.getMedian());
        this.sendFloat(epoch, sanitizedName, "75percentile", snapshot.get75thPercentile());
        this.sendFloat(epoch, sanitizedName, "95percentile", snapshot.get95thPercentile());
        this.sendFloat(epoch, sanitizedName, "98percentile", snapshot.get98thPercentile());
        this.sendFloat(epoch, sanitizedName, "99percentile", snapshot.get99thPercentile());
        this.sendFloat(epoch, sanitizedName, "999percentile", snapshot.get999thPercentile());
    }

    protected void printVmMetrics(long epoch) {
        this.sendFloat(epoch, "jvm.memory", "heap_usage", this.vm.heapUsage());
        this.sendFloat(epoch, "jvm.memory", "non_heap_usage", this.vm.nonHeapUsage());
        for (Map.Entry<String, Double> entry : this.vm.memoryPoolUsage().entrySet()) {
            this.sendFloat(epoch, "jvm.memory.memory_pool_usages", this.sanitizeString(entry.getKey()), entry.getValue());
        }
        this.sendInt(epoch, "jvm", "daemon_thread_count", this.vm.daemonThreadCount());
        this.sendInt(epoch, "jvm", "thread_count", this.vm.threadCount());
        this.sendInt(epoch, "jvm", "uptime", this.vm.uptime());
        this.sendFloat(epoch, "jvm", "fd_usage", this.vm.fileDescriptorUsage());
        for (Map.Entry<Object, Double> entry : this.vm.threadStatePercentages().entrySet()) {
            this.sendFloat(epoch, "jvm.thread-states", ((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.vm.garbageCollectors().entrySet()) {
            String name = "jvm.gc." + this.sanitizeString((String)entry.getKey());
            this.sendInt(epoch, name, "time", ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS));
            this.sendInt(epoch, name, "runs", ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getRuns());
        }
    }

    public static class DefaultSocketProvider
    implements SocketProvider {
        private final String host;
        private final int port;

        public DefaultSocketProvider(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public Socket get() throws Exception {
            return new Socket(this.host, this.port);
        }
    }
}

