/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceClient;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceResponse;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.Response;
import net.snowflake.client.jdbc.internal.amazonaws.ResponseMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.HandlerChainFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.ExecutionContext;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.http.JsonErrorResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.http.JsonResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.internal.StaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.RequestMetricCollector;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.AWSKMS;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateAliasRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateGrantRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateGrantResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateKeyResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DecryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DecryptResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DeleteAliasRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DescribeKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DescribeKeyResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DisableKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DisableKeyRotationRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EnableKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EnableKeyRotationRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EncryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EncryptResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateDataKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateDataKeyResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateRandomRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateRandomResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GetKeyPolicyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GetKeyPolicyResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GetKeyRotationStatusRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GetKeyRotationStatusResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListAliasesRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListAliasesResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListGrantsRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListGrantsResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListKeyPoliciesRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListKeyPoliciesResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListKeysRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListKeysResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.PutKeyPolicyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ReEncryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ReEncryptResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.RetireGrantRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.RevokeGrantRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.UpdateAliasRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.UpdateKeyDescriptionRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.AlreadyExistsExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.CreateAliasRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.CreateGrantRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.CreateGrantResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.CreateKeyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.CreateKeyResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DecryptRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DecryptResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DeleteAliasRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DependencyTimeoutExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DescribeKeyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DescribeKeyResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DisableKeyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DisableKeyRotationRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.DisabledExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.EnableKeyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.EnableKeyRotationRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.EncryptRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.EncryptResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateDataKeyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateDataKeyResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateDataKeyWithoutPlaintextResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateRandomRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GenerateRandomResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GetKeyPolicyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GetKeyPolicyResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GetKeyRotationStatusRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.GetKeyRotationStatusResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidAliasNameExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidArnExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidCiphertextExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidGrantTokenExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidKeyUsageExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.InvalidMarkerExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.KMSInternalExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.KeyUnavailableExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.LimitExceededExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListAliasesRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListAliasesResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListGrantsRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListGrantsResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListKeyPoliciesRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListKeyPoliciesResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListKeysRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ListKeysResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.NotFoundExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.PutKeyPolicyRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ReEncryptRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.ReEncryptResultJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.RetireGrantRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.RevokeGrantRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.UnsupportedOperationExceptionUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.UpdateAliasRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform.UpdateKeyDescriptionRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonErrorUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetrics;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class AWSKMSClient
extends AmazonWebServiceClient
implements AWSKMS {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSKMS.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSKMSClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSKMSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSKMSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSKMSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSKMSClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSKMSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSKMSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSKMSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSKMSClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new DisabledExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new KMSInternalExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DependencyTimeoutExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidCiphertextExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MalformedPolicyDocumentExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidKeyUsageExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidArnExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidMarkerExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidGrantTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new KeyUnavailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidAliasNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedOperationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("kms.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/net/snowflake/client/jdbc/internal/amazonaws/services/kms/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/net/snowflake/client/jdbc/internal/amazonaws/services/kms/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyResult createKey(CreateKeyRequest createKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateKeyRequestMarshaller().marshall(super.beforeMarshalling(createKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateKeyResultJsonUnmarshaller unmarshaller = new CreateKeyResultJsonUnmarshaller();
            JsonResponseHandler<CreateKeyResult> responseHandler = new JsonResponseHandler<CreateKeyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateKeyResult createKeyResult = (CreateKeyResult)response.getAwsResponse();
            return createKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptResult encrypt(EncryptRequest encryptRequest) {
        ExecutionContext executionContext = this.createExecutionContext(encryptRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EncryptRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EncryptRequestMarshaller().marshall(super.beforeMarshalling(encryptRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EncryptResultJsonUnmarshaller unmarshaller = new EncryptResultJsonUnmarshaller();
            JsonResponseHandler<EncryptResult> responseHandler = new JsonResponseHandler<EncryptResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EncryptResult encryptResult = (EncryptResult)response.getAwsResponse();
            return encryptResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyPolicyResult getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKeyPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKeyPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKeyPolicyRequestMarshaller().marshall(super.beforeMarshalling(getKeyPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetKeyPolicyResultJsonUnmarshaller unmarshaller = new GetKeyPolicyResultJsonUnmarshaller();
            JsonResponseHandler<GetKeyPolicyResult> responseHandler = new JsonResponseHandler<GetKeyPolicyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetKeyPolicyResult getKeyPolicyResult = (GetKeyPolicyResult)response.getAwsResponse();
            return getKeyPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateKeyDescriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateKeyDescriptionRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateKeyDescriptionRequestMarshaller().marshall(super.beforeMarshalling(updateKeyDescriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeysResult listKeys(ListKeysRequest listKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeysRequestMarshaller().marshall(super.beforeMarshalling(listKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListKeysResultJsonUnmarshaller unmarshaller = new ListKeysResultJsonUnmarshaller();
            JsonResponseHandler<ListKeysResult> responseHandler = new JsonResponseHandler<ListKeysResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListKeysResult listKeysResult = (ListKeysResult)response.getAwsResponse();
            return listKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyResult generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateDataKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateDataKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateDataKeyRequestMarshaller().marshall(super.beforeMarshalling(generateDataKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GenerateDataKeyResultJsonUnmarshaller unmarshaller = new GenerateDataKeyResultJsonUnmarshaller();
            JsonResponseHandler<GenerateDataKeyResult> responseHandler = new JsonResponseHandler<GenerateDataKeyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GenerateDataKeyResult generateDataKeyResult = (GenerateDataKeyResult)response.getAwsResponse();
            return generateDataKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGrantResult createGrant(CreateGrantRequest createGrantRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGrantRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGrantRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGrantRequestMarshaller().marshall(super.beforeMarshalling(createGrantRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateGrantResultJsonUnmarshaller unmarshaller = new CreateGrantResultJsonUnmarshaller();
            JsonResponseHandler<CreateGrantResult> responseHandler = new JsonResponseHandler<CreateGrantResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateGrantResult createGrantResult = (CreateGrantResult)response.getAwsResponse();
            return createGrantResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResult listAliases(ListAliasesRequest listAliasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAliasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAliasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAliasesRequestMarshaller().marshall(super.beforeMarshalling(listAliasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListAliasesResultJsonUnmarshaller unmarshaller = new ListAliasesResultJsonUnmarshaller();
            JsonResponseHandler<ListAliasesResult> responseHandler = new JsonResponseHandler<ListAliasesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListAliasesResult listAliasesResult = (ListAliasesResult)response.getAwsResponse();
            return listAliasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyWithoutPlaintextResult generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateDataKeyWithoutPlaintextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateDataKeyWithoutPlaintextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateDataKeyWithoutPlaintextRequestMarshaller().marshall(super.beforeMarshalling(generateDataKeyWithoutPlaintextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GenerateDataKeyWithoutPlaintextResultJsonUnmarshaller unmarshaller = new GenerateDataKeyWithoutPlaintextResultJsonUnmarshaller();
            JsonResponseHandler<GenerateDataKeyWithoutPlaintextResult> responseHandler = new JsonResponseHandler<GenerateDataKeyWithoutPlaintextResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GenerateDataKeyWithoutPlaintextResult generateDataKeyWithoutPlaintextResult = (GenerateDataKeyWithoutPlaintextResult)response.getAwsResponse();
            return generateDataKeyWithoutPlaintextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAliasRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAliasRequestMarshaller().marshall(super.beforeMarshalling(deleteAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAlias(UpdateAliasRequest updateAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAliasRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAliasRequestMarshaller().marshall(super.beforeMarshalling(updateAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableKeyRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableKeyRotationRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableKeyRotationRequestMarshaller().marshall(super.beforeMarshalling(enableKeyRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retireGrant(RetireGrantRequest retireGrantRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retireGrantRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetireGrantRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetireGrantRequestMarshaller().marshall(super.beforeMarshalling(retireGrantRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKeyResult describeKey(DescribeKeyRequest describeKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeKeyRequestMarshaller().marshall(super.beforeMarshalling(describeKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeKeyResultJsonUnmarshaller unmarshaller = new DescribeKeyResultJsonUnmarshaller();
            JsonResponseHandler<DescribeKeyResult> responseHandler = new JsonResponseHandler<DescribeKeyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeKeyResult describeKeyResult = (DescribeKeyResult)response.getAwsResponse();
            return describeKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGrantsResult listGrants(ListGrantsRequest listGrantsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGrantsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGrantsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGrantsRequestMarshaller().marshall(super.beforeMarshalling(listGrantsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListGrantsResultJsonUnmarshaller unmarshaller = new ListGrantsResultJsonUnmarshaller();
            JsonResponseHandler<ListGrantsResult> responseHandler = new JsonResponseHandler<ListGrantsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListGrantsResult listGrantsResult = (ListGrantsResult)response.getAwsResponse();
            return listGrantsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecryptResult decrypt(DecryptRequest decryptRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decryptRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecryptRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DecryptRequestMarshaller().marshall(super.beforeMarshalling(decryptRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DecryptResultJsonUnmarshaller unmarshaller = new DecryptResultJsonUnmarshaller();
            JsonResponseHandler<DecryptResult> responseHandler = new JsonResponseHandler<DecryptResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DecryptResult decryptResult = (DecryptResult)response.getAwsResponse();
            return decryptResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateRandomResult generateRandom(GenerateRandomRequest generateRandomRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateRandomRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateRandomRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateRandomRequestMarshaller().marshall(super.beforeMarshalling(generateRandomRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GenerateRandomResultJsonUnmarshaller unmarshaller = new GenerateRandomResultJsonUnmarshaller();
            JsonResponseHandler<GenerateRandomResult> responseHandler = new JsonResponseHandler<GenerateRandomResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GenerateRandomResult generateRandomResult = (GenerateRandomResult)response.getAwsResponse();
            return generateRandomResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyRotationStatusResult getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKeyRotationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKeyRotationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKeyRotationStatusRequestMarshaller().marshall(super.beforeMarshalling(getKeyRotationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetKeyRotationStatusResultJsonUnmarshaller unmarshaller = new GetKeyRotationStatusResultJsonUnmarshaller();
            JsonResponseHandler<GetKeyRotationStatusResult> responseHandler = new JsonResponseHandler<GetKeyRotationStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetKeyRotationStatusResult getKeyRotationStatusResult = (GetKeyRotationStatusResult)response.getAwsResponse();
            return getKeyRotationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableKeyRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableKeyRotationRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableKeyRotationRequestMarshaller().marshall(super.beforeMarshalling(disableKeyRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyPoliciesResult listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeyPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeyPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeyPoliciesRequestMarshaller().marshall(super.beforeMarshalling(listKeyPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListKeyPoliciesResultJsonUnmarshaller unmarshaller = new ListKeyPoliciesResultJsonUnmarshaller();
            JsonResponseHandler<ListKeyPoliciesResult> responseHandler = new JsonResponseHandler<ListKeyPoliciesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListKeyPoliciesResult listKeyPoliciesResult = (ListKeyPoliciesResult)response.getAwsResponse();
            return listKeyPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestMarshaller().marshall(super.beforeMarshalling(createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putKeyPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutKeyPolicyRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutKeyPolicyRequestMarshaller().marshall(super.beforeMarshalling(putKeyPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableKey(DisableKeyRequest disableKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableKeyRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableKeyRequestMarshaller().marshall(super.beforeMarshalling(disableKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReEncryptResult reEncrypt(ReEncryptRequest reEncryptRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reEncryptRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReEncryptRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReEncryptRequestMarshaller().marshall(super.beforeMarshalling(reEncryptRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReEncryptResultJsonUnmarshaller unmarshaller = new ReEncryptResultJsonUnmarshaller();
            JsonResponseHandler<ReEncryptResult> responseHandler = new JsonResponseHandler<ReEncryptResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReEncryptResult reEncryptResult = (ReEncryptResult)response.getAwsResponse();
            return reEncryptResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeGrant(RevokeGrantRequest revokeGrantRequest) {
        ExecutionContext executionContext = this.createExecutionContext(revokeGrantRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RevokeGrantRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RevokeGrantRequestMarshaller().marshall(super.beforeMarshalling(revokeGrantRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableKey(EnableKeyRequest enableKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableKeyRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableKeyRequestMarshaller().marshall(super.beforeMarshalling(enableKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    @Override
    public CreateKeyResult createKey() throws AmazonServiceException, AmazonClientException {
        return this.createKey(new CreateKeyRequest());
    }

    @Override
    public ListKeysResult listKeys() throws AmazonServiceException, AmazonClientException {
        return this.listKeys(new ListKeysRequest());
    }

    @Override
    public ListAliasesResult listAliases() throws AmazonServiceException, AmazonClientException {
        return this.listAliases(new ListAliasesRequest());
    }

    @Override
    public void retireGrant() throws AmazonServiceException, AmazonClientException {
        this.retireGrant(new RetireGrantRequest());
    }

    @Override
    public GenerateRandomResult generateRandom() throws AmazonServiceException, AmazonClientException {
        return this.generateRandom(new GenerateRandomRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

