/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;

public class MatDesc {
    public static String QUERY_ID = "queryId";
    public static String SMK_ID = "smkId";
    public static String KEY_SIZE = "keySize";
    public static int DEFAULT_KEY_SIZE = 256;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final long smkId;
    private final String queryId;
    private final int keySize;

    public MatDesc(long smkId, String queryId, int keySize) {
        this.smkId = smkId;
        this.queryId = queryId;
        this.keySize = keySize;
    }

    public MatDesc(long smkId, String queryId) {
        this(smkId, queryId, DEFAULT_KEY_SIZE);
    }

    public long getSmkId() {
        return this.smkId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public static MatDesc parse(String matdesc) {
        if (matdesc == null) {
            return null;
        }
        try {
            JsonNode jsonNode = mapper.readTree(matdesc);
            JsonNode queryIdNode = jsonNode.path(QUERY_ID);
            if (queryIdNode.isMissingNode() || queryIdNode.isNull()) {
                return null;
            }
            JsonNode smkIdNode = jsonNode.path(SMK_ID);
            if (smkIdNode.isMissingNode() || smkIdNode.isNull()) {
                return null;
            }
            String queryId = queryIdNode.asText();
            long smkId = smkIdNode.asLong();
            JsonNode keySizeNode = jsonNode.path(KEY_SIZE);
            if (!keySizeNode.isMissingNode() && !keySizeNode.isNull()) {
                return new MatDesc(smkId, queryId, keySizeNode.asInt());
            }
            return new MatDesc(smkId, queryId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String toString() {
        ObjectNode obj = mapper.createObjectNode();
        obj.put(QUERY_ID, this.queryId);
        obj.put(SMK_ID, Long.toString(this.smkId));
        obj.put(KEY_SIZE, Integer.toString(this.keySize));
        return obj.toString();
    }
}

